static char qmove_rcsid[]="qmove.c,v 1.2 1994/11/28 16:55:47 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qmove.c,v
 * Revision 1.2  1994/11/28  16:55:47  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:28:24  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qmove_popup;
static Widget           widget_qmoverc;
static Widget           widget_qmovelabel;
static Widget           widget_qmoveframe;
static Widget           widget_qmovemenu;
static Widget           widget_qmovemain;
static Widget           widget_qmoveexec;
static Widget           widget_qmoveclear;
static Widget           widget_qmoveclose;
static Widget           widget_qmoveseparator;
static Widget           widget_qmoveopt;

struct optionstruct qmovemenu[]={
  0,"User List  ","-h",INPUTTYPE,NULL,NULL,
  0,"Help       ","-help",FLAGTYPE,"False",NULL,
  0,"Verify     ","-verify",FLAGTYPE,"False",NULL,
  0,"Destination",NULL,INPUTTYPE,NULL,NULL,
  0,"Job ID List",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qmoveexec - Activate callback for exec
 */
XtCallbackProc pb_qmoveexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QMOVE_BINARY,qmovemenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qmoveclear - Activate callback for clear
 */
XtCallbackProc pb_qmoveclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qmovemenu);
}


/***********************************************************
 * pb_qmoveclose - Activate callback for close
 */

XtCallbackProc pb_qmoveclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qmove_dialog - Create widgets used for the qmove menu
 */
int create_qmove_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qmove_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qmove_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qmove_form = XtCreateManagedWidget("form", formWidgetClass, qmove_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qmovelabel=
	XtCreateManagedWidget("Qmove",labelWidgetClass,qmove_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qmovelabel); ii++;
  widget_qmovemain=XtCreateManagedWidget("box",formWidgetClass,qmove_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qmovemain,NULL,"Exec",(XtCallbackProc)pb_qmoveexec,NULL);
  clear=QmonAddButtonN(widget_qmovemain,exec,"Clear",(XtCallbackProc)pb_qmoveclear,NULL);
  close=QmonAddButtonN(widget_qmovemain,clear,"Close",(XtCallbackProc)pb_qmoveclose,NULL);

  widget_qmoveopt=createmenuoptions(qmove_form,widget_qmovemain,qmovemenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qmove - Open the qmove menu
 */
int openwidget_qmove()
{
  XtPopup(qmove_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qmove - Close the qmove menu
 */
int closewidget_qmove()
{
  XtPopdown(qmove_popup);
}
