#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"
#include <stdio.h>

void dqs_die();
void dqs_die_young();

main(argc,argv)
     int argc;
     char **argv;
     
{
  
  int i;
  
  DENTER_MAIN((DQS_EVENT,"dqs_random"));
  
  for (i=0;i<argc;i++)
    printf(">%s<",argv[i]);
  
  i=dqs_rand(60,600);
  
  printf("\n\n I will die in %d seconds\n",i);
  fflush(stdout);
  
  sigalrm_vec.sa_handler=dqs_die;
  sigemptyset(&sigalrm_vec.sa_mask);
  sigalrm_vec.sa_flags=0;
  sigaction(SIGALRM,&sigalrm_vec,&sigalrm_ovec);
  
  sigterm_vec.sa_handler=dqs_die_young;
  sigemptyset(&sigterm_vec.sa_mask);
  sigterm_vec.sa_flags=0;
  sigaction(DQS_SIGTERM,&sigterm_vec,&sigalrm_ovec);
  
  alarm(i);
  
  while(1){}
}

void dqs_die()
{
  printf("\n\n its a nice day to die\n");
  exit(0);
}

void dqs_die_young()
{
  printf("\n\n Oh No! I'm dying Young!!!\n");
  exit(0);
}
