#ifndef _OOPSER_OOPSD_H
#define _OOPSER_OOPSD_H
#include <sys/types.h>
#include "oopser.h"

/* Create the set command appropriate for this filename */
extern void *create_set_command(const char *name, size_t *len);

/* Open device with this major and minor */
extern int open_device(int major, int minor);

/* Add symbols from this file to the kernel */
extern int do_add_symbols(FILE *file, const char *prefix, int oopser_fd);

/* Mail an oops report. */
int mail_oops(const char *filename);

#endif /* __OOPSD_H */
