/*
 * Copyright (C) 2004 Red Hat UK Ltd.
 *
 * This file is released under the GPL.
 */

#ifndef DM_BH_RECORD_H
#define DM_BH_RECORD_H

#include <linux/fs.h>

/*
 * There are lots of mutable fields in the buffer-head struct that get
 * changed by the lower levels of the block layer.  Some targets,
 * such as multipath, may wish to resubmit a buffer-head on error.  The
 * functions in this file help the target record and restore the
 * original buffer-head state.
 */
struct dm_bh_details {
	unsigned long b_rsector;
	kdev_t b_rdev;
};

static inline void dm_bh_record(struct dm_bh_details *bd,
				struct buffer_head *bh)
{
	bd->b_rsector = bh->b_rsector;
	bd->b_rdev = bh->b_rdev;
}

static inline void dm_bh_restore(struct dm_bh_details *bd,
				 struct buffer_head *bh)
{
	bh->b_rsector = bd->b_rsector;
	bh->b_rdev = bd->b_rdev;
}

#endif
