#ifndef _VTUNE_VTPROTO_H
#define _VTUNE_VTPROTO_H
/*
 *  vtproto.h
 *
 *  Copyright (C) 2002 Intel Corporation
 *  Author/Maintainer - George W Artz <george.w.artz@intel.com>
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
/*
 *  
 *  Author(s): 
 *
 *  File: vtproto.h
 *
 *  system: VTune Linux Sampling Driver
 *
 * ===========================================================================
 */

/*  VTUNE function prototypes */
#include "vtoshooks.h"

#ifdef linux32
int vtune_get_cpuid(unsigned long *pThisCPUID, unsigned long *pThisCPUfeatures);
void samp_apic_set_perf_lvt_int_mask(void);
void samp_apic_clear_perf_lvt_int_mask(void);
__u32 SAMP_Set_apic_perf_lvt(long apic_perf_lvt);
void SAMP_Set_Apic_Virtual_Wire_Mode(void);
#endif

#ifdef linux64
void ebs_intr(int irq, void *arg, struct pt_regs *regs);
#endif

ssize_t samp_write_module_file(struct file *, char *, size_t, loff_t *);
void samp_write_sample_file(void);

int vtune_sampconfig(void);
int vtune_sampstart(void);
int vtune_sampstop(void);
int vtune_sampabort(void);
ssize_t vtune_read(struct file *, char *, size_t, loff_t *);
ssize_t vtune_write(struct file *, const char *, size_t, loff_t *);
int vtune_open(struct inode *, struct file *);
int vtune_release(struct inode *inode, struct file *filp);
int vtune_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
void vtune_sampreset(void);
int vtune_sampuserstop(void);

void vdrv_init_emon_regs(void);
int vdrv_start_EBS(void);
void vdrv_stop_EBS(void);
void vdrv_get_perf_count(void);

int vdrv_init_sys(void);
int vdrv_remove_sys(void);

u32  samp_emon_interrupt(PINT_FRAME int_frame);
void samp_get_sample_lock(void);
void samp_free_sample_lock(void);
void samp_init_emon_regs(void *info);
void samp_start_profile_interrupt(void *info);
void samp_stop_profile_interrupt(void *info);
void samp_start_emon(void *info);
void samp_stop_emon(void);
void samp_restore_cpu_vectors(void);

int start_sampling6(samp_parm6 * sp6, int sp6_len);

PREG_SET get_reg_set_table(void);

void samp_start_delay(unsigned long);
void samp_max_sample_time_expired(unsigned long);
void samp_thread(void);
int samp_get_stats(sampinfo_t *);
int samp_get_parm(samp_parm3 *);

void free_mrlist(void);
int vdrvgetsysinfo(void);
int samp_write_csips_file(void);

ULARGE_INTEGER samp_read_msr(__u32 reg);

void samp_write_msr(__u32 reg, ULARGE_INTEGER val);

void get_CSD(__u32, __u32 *, __u32 *);

/* VTune Handlers */
typedef void (*timer_handler) (struct pt_regs * regs);
extern timer_handler vtune_handler;

typedef int (*vtune_exec_handler) (struct task_struct * p);
extern vtune_exec_handler vtune_exec_task;

/* ASM types (vtxsys.c) */
__u32 get_CPUID_EBX(void);
__u32 get_CPUID_EDX(void);
__u32 get_APICID(void);
__u32 IA32_exchange(__u32 *, __u32);
void save_clear_init_emon_regs_for_package(BOOLEAN);
void validate_emon_regs(void);
void driver_load(void);
void driver_open(void);
void driver_unload(void);
int init_driver_OS(void);
extern void t_ebs(void);
extern void samp_get_set_idt_entry(unsigned long, unsigned long, __u64 *);
extern void samp_restore_idt_entry(unsigned long, long long *);
extern void vtune_sys_init(void);
asmlinkage void vdrv_send_EOI(void);

/* vtexlib.c */
void set_IA32_family6_emon_defaults(void);
int samp_configure6(samp_parm6 * sp6, int sp6_len);
boolean_t set_event_I_ds(PREG_SET p_reg_set);
void read_cpu_perf_counters_for_current_cpu(void *info);

/* OS Services */
void_ptr allocate_pool(__u32 pool_type, __u32 i);
void free_pool(void_ptr i);

#endif /* _VTUNE_VTPROTO_H */
