/*
 * tools/lib/vg_deactivate.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * June 1998
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>

void vg_deactivate ( char *vg_name) {
   int ret = 0;

   if ( vg_check_active ( vg_name) == TRUE) {
      printf ( "%s -- trying to deactivate inconsistent "
               "volume group %s\n", cmd, vg_name);
      if ( ( ret = vg_remove ( vg_name)) < 0) {
         fprintf ( stderr, "%s -- ERROR %d trying to deactivate %s\n",
                             cmd, ret, vg_name);
      } else printf ( "%s -- volume group %s deactivated\n", cmd, vg_name);
   }

   return;
}
