/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines LLC interface to network layer 
 */


#ifndef LLC_IF_H
#define LLC_IF_H


/* Available primitives */
#define DATAUNIT_PRIM          0
#define CONNECT_PRIM           1
#define DATA_PRIM              2
#define DISCONNECT_PRIM        3
#define RESET_PRIM             4
#define FLOWCONTROL_PRIM       5
#define DISABLE_PRIM           6
#define XID_PRIM               7
#define TEST_PRIM              8
#define SAP_ACTIVATION         9
#define SAP_DEACTIVATION       10

#define NBR_PRIMITIVES         11

#define INDICATE               1
#define CONFIRM                2
 
/* Primitive type */
#define PRIM_TYPE_REQUEST      1
#define PRIM_TYPE_INDICATE     2
#define PRIM_TYPE_RESPONSE     3
#define PRIM_TYPE_CONFIRM      4


/* Reset reasons, remote entity or local LLC */
#define RESET_REASON_REMOTE        1
#define RESET_REASON_LOCAL         2


/* Disconnect reasons */
#define DISC_REASON_RX_DM_RSP_PDU          0
#define DISC_REASON_RX_DISC_CMD_PDU        1
#define DISC_REASON_ACK_TIMER_EXPIRED      2
 
/* Confirm reasons */
#define CONNECT		0	/* connect confirm & reset confirm */
#define DISCONNECT	1	/* connect confirm & reset confirm */
#define FAILED		2	/* connect confirm & reset confirm */	
#define IMPOSSIBLE	3	/* connect confirm */
#define RECEIVED	4	/* data conn */
#define REMOTE_BUSY	5	/* data conn */
#define REFUSE		6	/* data conn */
#define CONFLICT	7	/* disconnect conn */
#define RESET_DONE      8       /*  */


/* Structures and types */

/* SAP/MAC Address pair */
typedef struct
{
   us8                 lsap;
   us8                 mac [6];
} address_t;


/* Primitive-specific data */
typedef struct 
{
   address_t           source_addr;            /* used by request only */
   address_t           dest_addr;              /* used by request only */
   us8                 status;		       /* reason for failure */	
   us8                 priority;	       /* service_class */
   void *              device;                 /* (struct device *) */
   us32                connect_handle;         /* returned from REQUEST */
   us16                link_no; 
   us8 *               unit;                   /* recieved SABME  */
} prim_connect_t;


typedef struct
{
   us32                connect_handle;         /* takes place of addresses */
   us16                link_no;
   us8                 reason;                 /* not used by request */
} prim_disconnect_t;


typedef struct
{
   us32                connect_handle;         /* takes place of addresses */
   us16                link_no;
   us8                 reason;                 /* used only by indicate */
} prim_reset_t;


typedef struct
{
   us32                connect_handle;         /* takes place of addresses */
   us16                link_no;
   us32                amount;
} prim_flow_control_t;


typedef struct
{
   us32                connect_handle;
   us16		       link_no;
   us8                 priority;
   us8 *               unit;           /* pointer to frame */
   us8                 status;         /* reason */
   unsigned long       flags;          /* system flags */
} prim_data_t;

 /* Sending data in conection-less mode */
typedef struct
{
   address_t           source_addr;
   address_t           dest_addr;
   us8                 priority;
   us8 *               unit;           /* pointer to frame */
   us8                 lfb;	       /* largest frame bit (TR) */
} prim_unit_data_t;
                       

typedef struct
{
   address_t           source_addr;
   address_t           dest_addr;
   us8                 priority;
} prim_xid_t;
                       

typedef struct
{
   address_t           source_addr;
   address_t           dest_addr;
   us8                 priority;
   us8 *               unit;           /* pointer to frame */
} prim_test_t;
                       

typedef union
{
   prim_connect_t      conn;
   prim_disconnect_t   disc;
   prim_reset_t        res;
   prim_flow_control_t fc;
   prim_data_t         data;           /* data */
   prim_unit_data_t    udata;          /* unit data */
   prim_xid_t          xid;
   prim_test_t         test;
} prim_data_u;


/* Information block passed with all called primitives */
typedef struct
{
   us32                sap;            /* pointer to sap_t */
   us8                 primitive;
   prim_data_u *       data;
} prim_if_block_t;


typedef int           (*primitive_call_t)(prim_if_block_t * prim_if);


#ifdef LLC_IF_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_IF_C */


EXTRN us16         llc_sap_open (primitive_call_t network_indicate,
                           primitive_call_t network_confirm, us8 local_sap,
                                                              us32 * sap_h);
EXTRN us16         llc_sap_close (us32 sap_h);

#undef EXTRN
#endif /* LLC_IF_H */
