/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgreport.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    SKGDocument document1;
    SKGTESTERROR(QLatin1String("PARAM:initialize"), document1.initialize(), true)

    SKGReport* rep = document1.getReport();
    rep->getPeriod();
    rep->setPeriod(QLatin1String("2013-01"));
    rep->getPrevious();
    SKGTEST(QLatin1String("REP:getMonth"), rep->getPeriod(), QLatin1String("2013-01"))
    SKGTEST(QLatin1String("REP:getPreviousMonth"), rep->getPreviousPeriod(), QLatin1String("2012-12"))

    QString html;
    SKGTESTERROR(QLatin1String("REP:getReportFromTemplate"),  SKGReport::getReportFromTemplate(rep, SKGTest::getTestPath(QLatin1String("IN")) % "/missing.txt", html), false)

    rep->getPrevious();
    rep->setPeriod(QLatin1String("2013-02"));
    rep->cleanCache();
    delete rep;


    // End test
    SKGENDTEST()
}
