/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgreportbank.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    // ============================================================================
    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestpfs/personalfinancescore.skg"), true)

        SKGError err;
        auto* rep = qobject_cast<SKGReportBank*>(document1.getReport());

        rep->setPeriod(QLatin1String("2010"));
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), SKGServices::doubleToString(rep->getPersonalFinanceScoreDetails().value(QLatin1String("value")).toDouble()), QLatin1String("-0.04761904762"))
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), rep->getPersonalFinanceScoreDetails().value(QLatin1String("level")).toString(), QLatin1String("danger"))
        rep->setPeriod(QLatin1String("2011"));
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), SKGServices::doubleToString(rep->getPersonalFinanceScoreDetails().value(QLatin1String("value")).toDouble()), QLatin1String("3.75"))
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), rep->getPersonalFinanceScoreDetails().value(QLatin1String("level")).toString(), QLatin1String("warning"))
        rep->setPeriod(QLatin1String("2012"));
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), SKGServices::doubleToString(rep->getPersonalFinanceScoreDetails().value(QLatin1String("value")).toDouble()), QLatin1String("9.833333333"))
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), rep->getPersonalFinanceScoreDetails().value(QLatin1String("level")).toString(), QLatin1String("warning"))
        rep->setPeriod(QLatin1String("2013"));
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), SKGServices::doubleToString(rep->getPersonalFinanceScoreDetails().value(QLatin1String("value")).toDouble()), QLatin1String("11.95"))
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), rep->getPersonalFinanceScoreDetails().value(QLatin1String("level")).toString(), QLatin1String("success"))
        rep->setPeriod(QLatin1String("2014"));
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), SKGServices::doubleToString(rep->getPersonalFinanceScoreDetails().value(QLatin1String("value")).toDouble()), QLatin1String("35.95"))
        SKGTEST(QLatin1String("SKGReportBank:getPersonalFinanceScore"), rep->getPersonalFinanceScoreDetails().value(QLatin1String("level")).toString(), QLatin1String("success"))
    }

    // End test
    SKGENDTEST()
}
