/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"
#include "skgtestmacro.h"
#include <qstringliteral.h>
#include <utility>

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true) {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager impmissing(&document1, QUrl::fromLocalFile(QLatin1String("missingfile.ofx")));
            SKGTESTERROR(QLatin1String("imp1.importFile"), impmissing.importFile(), false)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/ofx_spec160_stmtrs_example.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        {
            // To check double import
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/ofx_spec160_stmtrs_example.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }
        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("999988"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("200.29"))
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/ofx_spec201_stmtrs_example.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("999988"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("200.29"))
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/t1.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("Investment account 12345 at broker ameritrade.com"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("1672.84"))
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/385366.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("Investment account 209830947 at broker fidelity.com"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-1.818989404e-12"))
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/430130.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("1234567L123"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-8238.77"))
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), account.getAttribute(QLatin1String("f_importbalance")), QLatin1String("-8238.77"))
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/ca_remi.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }
        QStringList oResult;
        SKGTESTERROR(QLatin1String("ACCOUNT:getDistinctValues"), document1.getDistinctValues(QLatin1String("account"), QLatin1String("t_name"), oResult), true)
        SKGTEST(QLatin1String("ACCOUNT:oResult.size"), oResult.size(), 5)


        /*SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1,QLatin1String("v_account"), QLatin1String("1234567L123"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"),SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("3366.86"))*/
    }

    {
        // Test import OFX with initial balance
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/initial_balance.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("40080030367683"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("5036.46"))
    }

    {
        // Test import OFX with initial balance after rename of account
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Create account
            SKGBEGINTRANSACTION(document1, QLatin1String("CREATE_ACCOUNT"), err)
            SKGTESTERROR(QLatin1String("DOC.addOrModifyAccount"), document1.addOrModifyAccount(QLatin1String("COURANT"), QLatin1String("111111"), QLatin1String("BANK")), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/bug_statement.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("COURANT"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("7645.86"))
    }

    {
        // Test BUG 234771
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Create an account without number
            SKGBEGINTRANSACTION(document1, QLatin1String("CREATE_ACCOUNT"), err)
            SKGTESTERROR(QLatin1String("DOC.addOrModifyAccount"), document1.addOrModifyAccount(QLatin1String("COURANT"), QLatin1String(""), QLatin1String("BANK")), true)
        }
        {
            // Create an account without number
            SKGBEGINTRANSACTION(document1, QLatin1String("CREATE_ACCOUNT"), err)
            SKGTESTERROR(QLatin1String("DOC.addOrModifyAccount"), document1.addOrModifyAccount(QLatin1String("COURANT2"), QLatin1String(""), QLatin1String("BANK")), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/234771.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        // Test BUG 319706
        bool existMode = false;
        SKGTESTERROR(QLatin1String("doc.existObjects"), document1.existObjects(QLatin1String("operation"), QLatin1String("t_mode<>''"), existMode), true)
        SKGTESTBOOL("doc.existMode", existMode, true)
    }

    {
        // Test UTF-8 - 284843
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/284843.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        int nb = 0;
        SKGTESTERROR(QLatin1String("PAYEE.getNbObjects"),
                     document1.getNbObjects(QLatin1String("v_payee"), "t_name='" % QStringLiteral("カ－ド") % "'", nb),
                     true)
        SKGTEST(QLatin1String("PAYEE.getNbObjects"), nb, 1)
        document1.dump(DUMPPAYEE);
    }

    {
        // Test UTF-8
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/UTF8.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test 255133
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/exception.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/missing_file.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), false)
        }
    }

    {
        // Test export OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGImportExportManager exp(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtestimportofx/export.ofx"));
            SKGTESTERROR(QLatin1String("imp1.exportFile"), exp.exportFile(), false)
        }
    }

    {
        // Test 336320
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/336320.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        int nb1 = 0;
        SKGTESTERROR(QLatin1String("PAYEE.getNbObjects"), document1.getNbObjects(QLatin1String("operation"), QLatin1String(""), nb1), true)

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/336320.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        int nb2 = 0;
        SKGTESTERROR(QLatin1String("PAYEE.getNbObjects"), document1.getNbObjects(QLatin1String("operation"), QLatin1String(""), nb2), true)

        SKGTEST(QLatin1String("PAYEE.getNbObjects"), nb1, nb2)
    }

    {
        // Test handling of debit amount with wrong sign
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/debit_pos.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        bool existDebitPos = false;
        SKGTESTERROR(QLatin1String("doc.existObjects"), document1.existObjects(QLatin1String("v_operation"), QLatin1String("t_mode='Debit' and f_currentamount>0"), existDebitPos), true)
        SKGTESTBOOL("doc.existDebitPos", existDebitPos, false)
    }

    {
        // Test import OFX with missing id on transactions (Theo Raves)
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/mut.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("11111111000"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-12.34"))
    }

    {
        // Test import OFX from GNUCASH fr Android
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/20150818_133327_gnucash_export.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test import OFX from GNUCASH fr Android
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/FEE.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("1234567L123"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-18294.69"))
    }

    {
        // 406321
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/406321.skg"), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/406321.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        // 406741
        int nb2 = 0;
        SKGTESTERROR(QLatin1String("imp1.getNbObjects"), document1.getNbObjects(QLatin1String("operation"), QLatin1String("d_date>'2000-01-01'"), nb2), true)
        SKGTEST(QLatin1String("OPERATION:nb"), SKGServices::intToString(nb2), QLatin1String("5"))
    }

    {
        // 406321
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/406321.skg"), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/406321_2.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }
    }

    {
        // 412494
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/412494.qfx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            SKGDocument::SKGMessageList messages;
            SKGTESTERROR(QLatin1String("imp1.getMessages"), document1.getMessages(document1.getCurrentTransaction(), messages, true), true)
            bool test = false;
            for (const auto& msg : std::as_const(messages)) {
                SKGTRACE << "Message:" << msg.Text << Qt::endl;
                if (msg.Text.contains(QLatin1String("0 transactions imported")) ||
                    msg.Text.contains(QLatin1String("1 transaction imported"))) {
                    test = true;
                }
            }
            SKGTEST(QLatin1String("message.0 transactions imported"), static_cast<unsigned int>(test), 1)
        }
    }

    {
        // 421302
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Create an account without number
            SKGBEGINTRANSACTION(document1, QLatin1String("CREATE_ACCOUNT"), err)
            SKGTESTERROR(QLatin1String("DOC.addOrModifyAccount"), document1.addOrModifyAccount(QLatin1String("COURANT"), QLatin1String("5823485"), QLatin1String("BANK")), true)
            SKGObjectBase account;
            SKGTESTERROR(QLatin1String("DOC.getObject"), document1.getObject(QLatin1String("v_account"), QLatin1String("t_name='COURANT'"), account), true)
            SKGTESTERROR(QLatin1String("ACCOUNT.setProperty"), account.setProperty(QLatin1String("alias"), QLatin1String("XXXX485")), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_OFX"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportofx/XXXX485.ofx"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            document1.dump(DUMPACCOUNT | DUMPPARAMETERS);
            int nb2 = 0;
            SKGTESTERROR(QLatin1String("imp1.getNbObjects"), document1.getNbObjects(QLatin1String("account"), QString(), nb2), true)
            SKGTEST(QLatin1String("ACCOUNT:nb"), SKGServices::intToString(nb2), QLatin1String("1"))
        }
    }
    // End test
    SKGENDTEST()
}
