/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test import full_check.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_check.iif"));
            imp1.setCodec(QLatin1String("UTF-8"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Checking")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-36.15"))
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("EXPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtestimportiif/full_check.iif"));
            imp1.setCodec(QLatin1String("UTF-8"));
            SKGTESTERROR(QLatin1String("IIF.exportFile"), imp1.exportFile(), true)
        }
    }

    {
        // Test import full_deposit.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_deposit.iif"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Checking")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("10000"))
        }
    }

    {
        // Test import full_bill.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_bill.iif"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Accounts Payable")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-59.25"))
        }
    }

    {
        // Test import full_cash_sale.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_cash_sale.iif"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Undeposited Funds")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("1969.98"))
        }
    }

    {
        // Test import full_transfer.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_transfer.iif"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Checking")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-500"))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Savings")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("500"))
        }
    }

    {
        // Test import full_bill_payment.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_bill_payment.iif"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Checking")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-35"))
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Accounts Payable")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("35"))
        }
    }

    {
        // Test import full_customer_payment.iif
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_IIF"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportiif/full_customer_payment.iif"));
            SKGTESTERROR(QLatin1String("IIF.importFile"), imp1.importFile(), true)
        }

        SKGAccountObject la;
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Undeposited Funds")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("53.5"))
            la = account;
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("IIF.setName"), account.setName(QLatin1String("Accounts Receivable")), true)
            SKGTESTERROR(QLatin1String("IIF.load"), account.load(), true)
            SKGTEST(QLatin1String("IIF:getValue"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-53.5"))
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("EXPORT_IIF"), err)
            SKGImportExportManager exp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtestimportiif/export_all.iif"));
            SKGTESTERROR(QLatin1String("IIF.exportFile"), exp1.exportFile(), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("EXPORT_IIF"), err)
            SKGImportExportManager exp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtestimportiif/export_la.iif"));
            QMap<QString, QString> params;
            params[QLatin1String("uuid_of_selected_accounts_or_operations")] = la.getUniqueID();
            exp1.setExportParameters(params);
            SKGTESTERROR(QLatin1String("IIF.exportFile"), exp1.exportFile(), true)
        }
    }
    // End test
    SKGENDTEST()
}
