/***************************************************************************
                          ksynkconnection.cpp  -  description
                             -------------------
    begin                : Sun Aug 19 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kconfig.h>

#include "ksynkconnection.h"
#include "global.h"

KSynkConnection::KSynkConnection()
{
    Name="New Connection";
    m_ignoreModificationTime = false;
}

KSynkConnection::KSynkConnection(const KSynkConnection & old)
{
    *this = old;
}

KSynkConnection& KSynkConnection::operator=( const KSynkConnection& old )
{
    Name=old.Name;
    LocalURL=old.LocalURL;
    RemoteURL=old.RemoteURL;
    m_ignoreModificationTime = old.m_ignoreModificationTime;

    return *this;
}

KSynkConnection::~KSynkConnection()
{
}

const QString& KSynkConnection::getName() const
{
    return Name;
}

void KSynkConnection::setName( const QString& _newVal)
{
    Name = _newVal;
}

const KURL& KSynkConnection::getRemoteURL() const
{
    return RemoteURL;
}

void KSynkConnection::setRemoteURL( const KURL& _newVal)
{
    RemoteURL = _newVal;
}

const KURL& KSynkConnection::getLocalURL() const
{
    return LocalURL;
}
void KSynkConnection::setLocalURL( const KURL& _newVal)
{
    LocalURL = _newVal;
}

bool KSynkConnection::ignoreModifcationTime() const
{
    return m_ignoreModificationTime;
}
void KSynkConnection::setIgnoreModificationTime( bool ignore )
{
    m_ignoreModificationTime = ignore;
}

bool KSynkConnection::isValid() const
{
    return LocalURL.isValid() && RemoteURL.isValid() && !Name.isEmpty();
}

/** Writes the connection to the specified KConfig object
 */
void KSynkConnection::writeToConfig(KConfig* config)
{
    config->setGroup(CONNECTION_PREFIX+Name);
    config->writeEntry("LocalURL",LocalURL.url());
    config->writeEntry("RemoteURL",RemoteURL.url());
    config->writeEntry("IgnoreModificationTime", m_ignoreModificationTime);
}

/** Reads all the settings for this connection from the specified KConfig object */
void KSynkConnection::loadFromConfig(KConfig * config,const QString & name)
{
    config->setGroup(CONNECTION_PREFIX+name);
    Name=name;
    LocalURL=config->readEntry("LocalURL");
    RemoteURL=config->readEntry("RemoteURL");
    m_ignoreModificationTime = config->readBoolEntry("IgnoreModificationTime", false);
}

