/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@ePost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KHEISEVIEW_H
#define KHEISEVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlistview.h>

#include <kaction.h>

#include "articleview.h"


class KHeiseView: public QWidget
{
	Q_OBJECT
public:
	KHeiseView(QWidget *parent = 0, const char *name = 0);
	~KHeiseView();

	void readOptions();
	void saveOptions();

	void search(const RegMask &mask);
	void clear();

	int articleMagazine();
	int articleYear();
	int articleEdition();
	int articlePage();

	void plugContextMenu(KAction *action);
	void setViewAction(KAction *action);

	KListView *articleList();

private slots:
	void currentChangedSlot(QListViewItem *item);
	void executedSlot(QListViewItem *);

signals:
	void items(int);
	void hasSelection(bool);

private:
	ArticleView *articleview;
	QLabel *title, *subtitle, *author, *editor, *magazine, *edition, *page, *links;
	KAction *viewaction;

	int cur_mag, cur_edition, cur_year, cur_page;
};


inline int KHeiseView::articleMagazine()
{	return cur_mag; }


inline int KHeiseView::articleYear()
{	return cur_year % 100; }


inline int KHeiseView::articleEdition()
{	return cur_edition; }


inline int KHeiseView::articlePage()
{	return cur_page; }


inline void KHeiseView::plugContextMenu(KAction *action)
{	articleview->plugContextMenu(action); }


inline void KHeiseView::setViewAction(KAction *action)
{	viewaction = action; }


inline KListView *KHeiseView::articleList()
{	return articleview; }


#endif // KHEISEVIEW_H
