/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef APPENDDLG_H
#define APPENDDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qwidget.h>
#include <qlabel.h>

#include <kdialog.h>


class AppendDlg: public KDialog
{
	Q_OBJECT
public:
	AppendDlg(QWidget *parent = 0, const char *name = 0);
	virtual ~AppendDlg();

private slots:
	void slotHelp();
	void slotAppend();
	
private:
	void scanEntries();

	QLabel *ct_first, *ct_last, *ct_article_no;
	QLabel *ix_first, *ix_last, *ix_article_no;

	int ct_first_ed, ct_last_ed, ct_articles;
	int ix_first_ed, ix_last_ed, ix_articles;
};


#endif // APPENDDLG_H
