/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef MLOLOADER_H
#define MLOLOADER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qprogressdialog.h>
#include <qwidget.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qfile.h>

#include <kconfig.h>

#include "modem.h"


typedef struct fitem {
	char name[21];
	int year, month, day;
	int hour, minute, second;
	int size;
	struct fitem *next;
} fitem_t;



class MLOLoader: public QObject
{
	Q_OBJECT
public:
	MLOLoader(QWidget *parent = 0, const char *name = 0);
	~MLOLoader();

	bool startDownload();

public slots:
	void cancel();

private slots:
	void fetchModemLine(const QCString &line);
	void fetchXModemStatus(int pos);
	void fetchXModemDone(bool success);
	void fetchTimeout();
	
private:
	void init();
	void reset();
	void downloadFile();
	void writeCommand(const QCString &com, int msec);

	KConfig *config;
	
	bool load_new;
	bool delete_fax;

	Modem *modem;
	int status;
	int model;

	QCString command;

	fitem_t *fitems;
	int nfiles, count;

	QFile file;

signals:
	void totalSteps(int);
	void progress(int);

	void message(const QString &msg);
	void helpMessage(const QString &msg);
	void gotFile(const QString &name);
	void done();
};


#endif // MLOLOADER_H
