/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef PREVIEW_H
#define PREVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qevent.h>
#include <qpopupmenu.h>
#include <qscrollbar.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qframe.h>
#include <qsize.h>
#include <qpoint.h>
#include <qpainter.h>
#include <qpixmap.h>

#include <kmainwindow.h>
#include <kconfig.h>
#include <kaccel.h>
#include <kaction.h>
#include <klistbox.h>

#include "mlofile.h"

#include <X11/Xlib.h>


#define ID_PRE_FILE_PRINT           10010
#define ID_PRE_FILE_EXPORT          10020
#define ID_PRE_FILE_MAIL            10030
#define ID_PRE_FILE_CLOSE           10040

#define ID_PRE_VIEW_ZOOM_IN         11010
#define ID_PRE_VIEW_ZOOM_OUT        11020
#define ID_PRE_VIEW_ROTATE          11030

#define ID_PRE_GO_PREVIOUS          12010
#define ID_PRE_GO_NEXT              12020
#define ID_PRE_GO_FIRST             12030
#define ID_PRE_GO_LAST              12040

#define ID_PRE_SETTINGS_TOOLBAR     13010
#define ID_PRE_SETTINGS_STATUSBAR   13020
#define ID_PRE_SETTINGS_SAVEOPTIONS 13030

#define ID_PRE_STATUS_TIME          1001
#define ID_PRE_STATUS_SENDER        1002
#define ID_PRE_STATUS_PAGE          1003
#define ID_PRE_STATUS_SIZE          1004
#define ID_PRE_STATUS_ZOOM          1005
#define ID_PRE_STATUS_ANGLE         1006



class FaxScrollBox: public QFrame
{
	Q_OBJECT
public:
	FaxScrollBox(QWidget *parent = 0, const char *name = 0);
	~FaxScrollBox();

public slots:
	void setPageSize(QSize size);
	void setViewSize(QSize size);
	void setViewPos(QPoint pos);

protected:
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	void drawContents(QPainter *p);

signals:
	void move(int, int);

private:
	void setBackgroundMode();
	bool newGeometry();

	QPoint viewpos, mousepos;
	QSize pagesize, viewsize;
	QPoint m_pos;
	QSize m_size;
};


	
class FaxIconListItem: public QListBoxItem
{
public:
	FaxIconListItem(QListBox *listbox, const QPixmap &pixmap, int page);
	~FaxIconListItem();

	virtual int height(const QListBox *lb) const;
	
protected:
	void paint(QPainter *painter);

private:
	QPixmap m_pixmap;
	int m_page;
};


class FaxIconList: public KListBox
{
	Q_OBJECT
public:
	FaxIconList(QWidget *parent = 0, const char *name = 0);
	virtual ~FaxIconList();

	void showFax(const QString &name, bool lsb_first);

	void selectPage(int page);
};


class FaxWidget: public QWidget
{
	Q_OBJECT
public:
	FaxWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~FaxWidget();

	bool lsbFirst();

	void setImage(int w, int h, char *data);
	void deleteImage();

	void updateGeometry();
	bool x11EventFilter(XEvent *ev);

	Window window;

public slots:
	void setXScroll(int x);
	void setYScroll(int y);
	void move(int dx, int dy);
	void keyLeft();
	void keyRight();
	void keyUp();
	void keyDown();
	void keyPageUp();
	void keyPageDown();
	void keyHome();
	void keyEnd();

protected:
	void initKeyAccel();

	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);

signals:
	void resized(QSize);
	void moved(QPoint);

private:
	int sizex, sizey;
	int scrollx, scrolly;

	QScrollBar *hscroll, *vscroll;

	KAccel *keyAccel;

	Display *display;
	GC gc;
	bool lsb_first;
	XImage *image;
	int im_width, im_height;
	Cursor move_cursor;
	bool moving;
	int move_x, move_y;
};


inline bool FaxWidget::lsbFirst()
{ return lsb_first; }




class Preview: public KMainWindow
{
	Q_OBJECT
public:
	Preview(QWidget *parent = 0, const char *name = 0);
	virtual ~Preview();

	void showFax(const QString &name);

	FaxWidget *faxWidget();

protected:
  void initActions();
	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	
public slots:
	void readOptions();
	void saveOptions();
	
	void slotFilePrint();
	void slotFileExport();
	void slotFileMail();

	void slotViewZoomIn();
	void slotViewZoomOut();
	void slotViewRotate();

	void slotGoFirstPage();
	void slotGoPreviousPage();
	void slotGoNextPage();
	void slotGoLastPage();

	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	
	void slotStatusTime(const QDateTime &time);
	void slotStatusSender(const QString &text);
	void slotStatusPage();
	void slotStatusSize();
	void slotStatusZoom();
	void slotStatusAngle();
	
protected slots:
	void pageSelected(int index);

private:
	void deletePages();
	void showPage();
	void loadPage(int p);

	KConfig *config;

	QString m_name;

	char *page_datas[3];
	int page, pages;
	int page_width, page_height;
	bool page_fine;
	int zoom_width, zoom_height;
	int zoom;
	int angle;

  KAction *filePrint, *fileExport, *fileMail, *fileClose;
  KAction *viewZoomIn, *viewZoomOut, *viewRotate;
  KAction *goFirstPage, *goPreviousPage, *goNextPage, *goLastPage;
  KToggleAction *settingsShowToolbar, *settingsShowStatusbar;
  KAction *settingsSaveOptions;

	FaxScrollBox *fax_scroll;
	FaxIconList *fax_icons;
	FaxWidget *fax_widget;
	QWidget *view;
};


inline FaxWidget *Preview::faxWidget()
{ return fax_widget; }


#endif // PREVIEW_H
