/*
 * KMLOCfg
 *
 * A utility to configure modems of the ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef MLOLOADER_H
#define MLOLOADER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qobject.h>
#include <qwidget.h>
#include <qstring.h>
#include <qcstring.h>
#include <qdatetime.h>
#include <qfile.h>

#include <kconfig.h>

#include "modem.h"


#define MODEL_UNKNOWN     0
#define MODEL_OFFICE      1
#define MODEL_OFFICE_II   2
#define MODEL_ISDN_OFFICE 3

#define ID_MODEL_OFFICE       "MicroLink Office"
#define ID_MODEL_OFFICE_II    "MicroLink Office II"
#define ID_MODEL_ISDN_OFFICE  "MicroLink ISDN Office"

#define CONF_PORT_ISDN 0
#define CONF_PORT_AB1  1
#define CONF_PORT_AB2  2
#define CONF_AB_PORT_1  0
#define CONF_AB_PORT_2  1


#define LOADER_ACTION_NONE       0
#define LOADER_ACTION_CFG_READ   1
#define LOADER_ACTION_CFG_WRITE  2
#define LOADER_ACTION_FILE_READ  3
#define LOADER_ACTION_FILE_WRITE 4



typedef struct off_config_t {
	// MicroLink Office
	int  country;								// AT+GCI
	int  mem_free;							// AT$JMEM=Free
	bool fax_takeover;					// AT$JCFGF
	bool accept_full;
	bool announce_system;				// AT$JCFGM
	bool announce_number;
	bool announce_time;
	int  outgoing_message;
	bool fax_operation;					// AT$JCFGT
	bool voice_operation;
	bool voice_recording;
	bool hook_config;
	bool keyboard_config;
	bool accept_dtr;
	int  max_rec_time;					// AT$JCFGV
	int  min_rec_time;
	char rec_quality[9];
	bool rec_speaker;
	bool rec_monitor;
	char fax_id[21];						// AT$JFLI
	bool remote_query;					// AT$JPWD
	bool remote_config;
	char remote_pw[5];
	int  ring_number;						// AT$JRING
	bool ring_signal;
	bool suppress_ri;
	bool accept_early;
	int  rec_vol;								// AT$JVGR
	int  play_vol;							// AT$JVGT
	int  micro_vol;							// AT$JVGM
	int  speaker_vol;						// AT$JVGS
};


typedef struct offii_config_t {
	// MicroLink Office II
	int  country;								// AT+GCI
	char in_number[3][21];			// AT$JSPRN
};


typedef struct isdnoff_config_t {
	// MicroLink ISDN Office
	char msn_trans[3][21];			// AT$ICLI
	bool msn_do_trans[3];
	char msn_acc[3][3][21];			// AT$IMSN
	char eaz[3];								// AT$IEAZ
	bool in_ind[3][4];					// AT$ISCI
	char out_ind[3];						// AT$ISCO
	bool knock_enable[3];				// AT$IBIS
	bool accept_enable[3];
	char auto_dial_num[3][21];	// AT$IAD
	bool auto_dial[3];
	int  tot_charge[3];					// AT$ICI
	int  last_charge[3];
	bool reset_charge[3];
	int  country;								// AT$IPCS
	bool exchange_hook[2];			// AT$IEL;
	bool exchange_flash[2];
	char d_chn_prot[8];					// AT$IDP
};


typedef union model_config_t {
	struct off_config_t off;
	struct offii_config_t offii;
	struct isdnoff_config_t isdnoff;
};


typedef struct mlo_config_t {
	// All models
	char model;											// ATI6
	char firmware[41];							// ATI3
	QDateTime date_time;						// AT$JDATE, AT$JTIME
	bool sync_timer;

	union model_config_t mod;
};


class MLOLoader: public QObject
{
	Q_OBJECT
public:
	MLOLoader(QWidget * parent = 0, const char * name = 0);
	~MLOLoader();

	void setDefaultConfig();
	const mlo_config_t *getConfig();
	void setConfig(const mlo_config_t *conf);

	bool initModem();
	bool startRead();
	bool startWrite();
	
	bool startFileRead();
	bool startFileWrite();

public slots:
	void cancel();

protected slots:
	void fetchModemLine(const QCString &line);
	void fetchXModemStatus(int pos);
	void fetchXModemDone(bool success);
	void fetchTimeout();

private:
	void init();
	void reset();
	void fetchModemLineDown(const QCString &line);
	void fetchModemLineUp(const QCString &line);
	void downloadFile();
	void uploadFile();
	void createFile();
	void writeCommand(const QCString &com, int msec);
	void writeCommand(const QCString &com);

	KConfig *config;

	mlo_config_t c;

	Modem *modem;
	int action;
	int status;
	int model;
	int count;

	bool cfg_file;
	int cfg_file_size;

	QCString command;

signals:
	void totalSteps(int);
	void progress(int);
	
	void message(const QString &msg);
	void done(int action, bool success);
};


inline void MLOLoader::writeCommand(const QCString &com)
{ writeCommand(com, 2000); }


#endif // MLOLOADER_H
