#include <kmessagebox.h>
#include <kstddirs.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <unistd.h>
#include <fcntl.h>
#include <kapp.h>
#include <qdir.h>
#include "kscore.h"

extern "C" {
char *score_str(short m_char, short other, short level, short amulet);
void turn_into_games();
void turn_into_user();
long xxx(char);
void xxxx(char *, short);
}

KScoreList::KScoreList(int _user)
{
  KConfig *cfg=KGlobal::config();
  loaded=0;
  curr=0;
  user=_user;
  if (!user)
  {
    cfg->setGroup("Config");
    scorefile=cfg->readEntry("HostScoresFile");
    if (scorefile.isEmpty())
      scorefile=locate("appdata", "krogue.host.scores");
  } else scorefile=locateLocal("appdata", "krogue.user.scores");
  if ((loaded=loadFile(scorefile))<=0) return;
}

int KScoreList::loadFile(const QString &fn)
{
  int i, len;
  QFile f(fn);
  if (!user) turn_into_games();
  if (!QFile::exists(fn)) close(creat(QFile::encodeName(fn), 0644));
  if (!f.open(IO_ReadOnly))
  {
    turn_into_user();
    return -1;
  }
  if (!user) turn_into_user();
  xxx(1);
  nScores=0;
  for (i=0; i<10; i++)
  {
    len=f.readBlock((char *)&scores[i], sizeof(scores[i]));
    if (!len) break;
    nScores++;
    if (len!=sizeof(scores[i])) return -2;
    xxxx((char *)&scores[i], sizeof(scores[i]));
  }
  return 0;
}

int KScoreList::writeFile(const QString &fn)
{
  int i;
  QFile f(fn);
  if (!user) turn_into_games();
  if (!f.open(IO_ReadWrite))
  {
    if (!user) turn_into_user();
    return -1;
  }
  if (!user) turn_into_user();
  xxx(1);
  for (i=0; i<nScores; i++)
  {
    xxxx((char *)&scores[i], sizeof(scores[i]));
    f.writeBlock((char *)&scores[i], sizeof(scores[i]));
  }
  xxx(1);
  for (i=0; i<10; i++) xxxx((char *)&scores[i], sizeof(scores[i]));
  return 0;
}

int KScoreList::putScore(long gold, const char *name, const char *nick,
  short other, short level, char m_char, char amulet)
{
  KScore s;
  int oldpos, newpos, i;
  s.gold=gold;
  s.other=other;
  s.level=level;
  s.m_char=m_char;
  s.amulet=amulet;
  strcpy(s.name, name);
  strcpy(s.nick, nick);
  oldpos=nScores;
  if (user) oldpos=nScores; else
    for (i=0; i<nScores; i++)
      if (strcmp(s.name, scores[i].name)==0)
      {
        oldpos=i;
        break;
      }
  if (oldpos==nScores && nScores<10) nScores++;
    else if (oldpos!=nScores && scores[oldpos].gold>s.gold) return 10;
  newpos=oldpos;
  for (i=oldpos; i>0; i--)
  {
    if (scores[i-1].gold>s.gold) break;
    if (i<nScores) scores[i]=scores[i-1];
    newpos=i-1;
  }
//  printf("nScores=%d, oldpos=%d, newpos=%d\n", nScores, oldpos, newpos);
  if (newpos<10) scores[newpos]=s;
  curr=newpos+1;
  if (writeFile(scorefile)<0)
    KMessageBox::error(kapp->mainWidget(), i18n("can't write to scores file!"), i18n("Rogue"));
  return newpos;
}

int KScoreList::current()
{
  return curr;
}

void KScoreList::setNick(const char *name, const char *nick)
{
  int i;
  for (i=0; i<nScores; i++)
    if (!strcmp(name, scores[i].name))
      qstrncpy(scores[i].nick, nick, 30);
  writeFile(scorefile);
}

QString &KScoreList::desc(int i)
{

  if (descs[i].isNull())
    if (i<nScores)
    {
      if (!user)
      {
        if (scores[i].nick[0]) descs[i]=QString::fromUtf8(scores[i].nick);
          else descs[i]=QString::fromLocal8Bit(scores[i].name);
        descs[i]+=": ";
      }
      descs[i]+=QString::fromUtf8(score_str(scores[i].m_char, scores[i].other,
                                  scores[i].level, scores[i].amulet));
    } else descs[i]="";
  return descs[i];
}

QString &KScoreList::score(int i)
{
  if (scorestr[i].isNull())
    if (i<nScores) scorestr[i].setNum(scores[i].gold);
      else scorestr[i]="";
  return scorestr[i];
}

KScoreDlg::KScoreDlg(bool _user, QWidget *parent)
:KHTMLDlg(QSize(670, 330), parent)
{
  QString buf;
  user=_user;
  list=new KScoreList(_user);
  if (!list || list->loaded<0)
  {
    buf=i18n("Can't open score file %1").arg(list->scorefile);
    KMessageBox::error(parent, buf, i18n("Rogue"));
  } else load=1;
}

void KScoreDlg::listScores()
{
  char name[7], score[8];
  int i;
  if (!load) return;
  load=0;
  for (i=0; i<10; i++)
  {
    sprintf(name, "DESC%d", i+1);
    sprintf(score, "SCORE%d", i+1);
    setVar(name, list->desc(i));
    setVar(score, list->score(i));
  }
  if (list->current()!=0)
    setVar("CURR", QString::number(list->current()));
  setVar("TOP_TEN_ROGUEISTS", user?i18n("Your top ten scores"):
    i18n("Top Ten Rogueists"));
  setVar("RANK", i18n("Rank"));
  setVar("SCORE", i18n("Score"));
  setVar("NAME", i18n("Name"));
  loadFile("top10.qml");
}

int KScoreDlg::putScore(long gold, char *name, char *nick, short other, 
  short level, char m_char, char amulet)
{
  if (!load) return 10;
  return list->putScore(gold, name, nick, other, level, m_char, amulet);
}
