#include <qpushbutton.h>
#include <qwhatsthis.h>
#include <qkeycode.h>
#include <ktoolbar.h>
#include <klocale.h>
#include <kconfig.h>
#include <stdio.h>
#include <kapp.h>
#include "krogueqh.h"
#include "kmsgbar.h"
#include "kcmdr.h"
#include "kdun.h"

KMoreButton::KMoreButton(const QString &text, QWidget *parent, const char *name)
:QPushButton(text, parent, name)
{
  krwtSetMoreButton(this);
}

void KMoreButton::keyPressEvent(QKeyEvent *e)
{
  QKeyEvent ev(QEvent::KeyPress, Key_Space, ' ', e->state());
  switch (e->key())
  {
    case Key_Up:
    case Key_Down:
    case Key_Right:
    case Key_Left:
      break;
    case Key_Enter:
    case Key_Return:
      QPushButton::keyPressEvent(&ev);
      break;  
    default:
      QPushButton::keyPressEvent(e);
  }
}

KMsgBar::KMsgBar(QWidget *parent, char *name)
:KToolBar(parent, name)
{
  int cmbid;
  setFullSize(true);
  cmbid=insertCombo(i18n("Welcome to the Dungeons of Doom"), 0, FALSE,
    SIGNAL(activated(int)), this, SLOT(activ(int)));
  setItemAutoSized(cmbid);
  combo=getCombo(cmbid);
  krwtSetMsgBar(combo);
  krwtSetMsgBar(this);
  normal=new QFont(QFont::defaultFont());
  bold=new QFont(QFont::defaultFont());
  bold->setBold(true);
  combo->setFont(*bold);
  combo->setFocusPolicy(QWidget::NoFocus);
  inv=false;
  fmore=false;
  willQuit=false;
}

void KMsgBar::message(const QString &s)
{
  if (willQuit) return;
  if (!inv)
  {
    if (!fmore)
    {
      p=new KMoreButton(i18n("More..."), this);
      p->setMaximumHeight(combo->height());      
      pbid=insertWidget(1, 80, p);
      alignItemRight(1, true);
      p->setDefault(true);
      p->setFocus();      
      connect(p, SIGNAL(clicked()), SLOT(moreClick()));
      cmdr->disableCmds();
      dun->setFocusPolicy(QWidget::NoFocus);
      fmore=1;
      emit moreShown();
    }
//    printf("enter_loop()\n");
    kapp->enter_loop();
//    printf("exit_loop()\n");
  } else combo->setFont(*bold);
  inv=false;
  setMessage(s);
}

QString KMsgBar::getMessage(int i)
{
  return combo->text(i);
}

int KMsgBar::msgCount()
{
  return combo->count();
}

void KMsgBar::removeMore()
{
  if (fmore)
  {
    QWhatsThis::remove(getWidget(1));
    removeItem(1);
    delete p;
    cmdr->enableCmds();
    dun->setFocusPolicy(QWidget::StrongFocus);
    dun->setFocus();
    fmore=false;
  }
}

void KMsgBar::setMessage(const QString &msg)
{
  if (combo->count()>=20)
    combo->removeItem(combo->count()-1);
  combo->insertItem(msg, 0);
}

void KMsgBar::invMsg()
{
  if (!inv) combo->setFont(*normal);
  inv=true;
}

void KMsgBar::activ(int i)
{
  if (i!=0) combo->setCurrentItem(0);
}

void KMsgBar::moreClick(void)
{
  kapp->exit_loop();
}

bool KMsgBar::more()
{
  return fmore;
}

void KMsgBar::saveProperties(KConfig *cfg)
{
  int i;
  char buf[40];
  cfg->writeEntry("MsgCount", combo->count());
  for (i=0; i<combo->count(); i++)
  {
    snprintf(buf, 40, "MsgItem%d", i);
    cfg->writeEntry(buf, combo->text(i));
  }
  cfg->writeEntry("MsgInv", inv);
}

void KMsgBar::readProperties(KConfig *cfg)
{
  char buf[40];
  combo->clear();
  int count=cfg->readNumEntry("MsgCount"), i;
  if (cfg->readNumEntry("MsgInv")) invMsg();
  for (i=0; i<count; i++)
  {
    snprintf(buf, 40, "MsgItem%d", i);
    combo->insertItem(cfg->readEntry(buf));
  }
}
