/***************************************************************************
                          matrix.h  -  description
                             -------------------
    begin                : Mon Nov 12 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATRIX_H
#define MATRIX_H


/**
  *@author Jos Pablo Fernndez
  */

#include <qarray.h>

#include <iostream.h>        /* For DEBUG (print)  */


template<class type>
class Matrix : public QArray<type>
{
public:
	Matrix()  { }
	Matrix(int rows, int cols)  : QArray<type>(rows*cols)
	{
		Matrix::rows = rows ;
		Matrix::cols = cols ;
	}

	~Matrix() { }
	type get(int i, int j) {
		return ( QArray<type>::at(rows*i+j)  ) ;
	}
	void set(int i, int j, type value) {
		QArray<type>::at(rows*i+j) = value ;
	}
	
	void print() { /* DEBUG */
		int i, j ;
		int v ;
		for (i=0; i<rows; i++) {
			for (j=0; j<cols; j++) {
				v = get(i,j) ;
				if (v == -1) {
					cout << "  " ;
				} else {
					cout  << v << " " ;
				}
			}
			cout << endl ;
		}
	}

	bool isEqual(Matrix matrix2) {
		int i, j ;
		for (i=0; i<rows; i++)
			for (j=0; j< cols; j++)
				if (get(i,j)  != matrix2.get(i,j))
					return (false) ;
		return (true) ;
	}		

private:
	int rows ;
	int cols ;
} ;

#endif
