/***************************************************************************
                          ksquare.h  -  description
                             -------------------
    begin                : Sat Nov 10 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSQUARE_H
#define KSQUARE_H

#include <qwidget.h>
#include <qpixmap.h>

/**
  *@author Jos Pablo Fernndez
  */

class KSquare : public QWidget  {
   Q_OBJECT
public:
	enum State {Non=0, Empty, SmallCircle, X, O } ;
	enum Background {BgNon=0, BgSmallCircle, BgBlack, BgWhite } ;
	
	KSquare(QWidget *parent=0, const char *name=0,
		KSquare::Background the_background=KSquare::BgNon,
		KSquare::State state=KSquare::Non, int i=0, int j=0,
		int size = 40, QImage *img_background=0, QImage *image=0); 	
	~KSquare(); 	
	int getRow(void) ; 	
	int getCol(void) ; 	
	KSquare::State getState(void) ;
	void select(void) ;
	void unselect(void) ;	
	bool isSelected(void) ;
	void tip(void) ;
	void untip(void) ;

	void setBackground(QImage *img_background) ;
	void setImage(QImage *image) ;
	QImage *getImage(void) ;
	void draw(void) ;
		
public slots:
	void setState(KSquare::State state, QImage *image) ;
	void setBackground(KSquare::Background background) ;
	
signals:
	void changeRequest (KSquare::State state, KSquare *);
	
protected:
	/* Repintar la casilla */	
	void paintEvent (QPaintEvent *) ;
	
	/* Procesar la pulsacion con el raton */
	void mousePressEvent (QMouseEvent *) ;
	
private:
	int row ;
	int col ;
	int size ;
	
	bool selected ;
	bool tiped ;
	
	State state ;
	Background the_background ;
	QImage *image ;
	QPixmap *pixmap ;
};

#endif
