/***************************************************************************
                          ksquare.cpp  -  description
                             -------------------
    begin                : Sat Nov 10 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>

#include "ksquare.h"

KSquare::KSquare(QWidget *parent, const char *name,
	KSquare::Background background,
	KSquare::State state, int i, int j ) :
		QWidget(parent,name) { 	
	int minimum_size = 40 ; 	
	row = i ;
	col = j ;
	selected = false ;
	tiped = false ;
	
	KSquare::state = state ;
	KSquare::background = background ;
	setMinimumSize(minimum_size, minimum_size) ;
}

KSquare::~KSquare(){
}

int KSquare::getRow()
{
	return row ;
}

int KSquare::getCol()
{
	return col ;
}

KSquare::State KSquare::getState()
{
	return state ;
}

bool KSquare::select()
{
	selected = true ;
	return selected ;
}

bool KSquare::unselect()
{
	selected = false ;
	return selected ;
}

bool KSquare::isSelected()
{
	return selected ;
}

void KSquare::tip(void) {
	tiped = true ;
	update() ;
}

void KSquare::untip(void) {
	tiped = false ;
	update() ;
}


void KSquare::paintEvent (QPaintEvent *)
{

	/* Dibujo el fondo */
	QPainter back (this) ;
	
	switch (background) {
		case BgNon:
			break ;
		case BgWhite:
			back.fillRect(rect(), Qt::white) ;
			break ;
		case BgBlack:
			back.fillRect(rect(), Qt::black) ;
			break ;
		case BgSmallCircle:
			back.fillRect(rect(), Qt::black) ;			
			/* back.setPen(QPen (Qt::blue, 3, SolidLine)) ; */
			/* back.setBrush (QBrush(Qt::blue, Qt::Dense4Pattern) ) ; */
			back.setBrush(Qt::gray) ;
			back.drawEllipse(
				rect().x()+rect().width()*1/8, rect().y()+height()*1/8,
				rect().width()*6/8, rect().height()*6/8 ) ;
			break ;
		}
		
	/* Dibujo la ficha */	
	QPainter qpainter (this) ;
	
	switch (state) {
		case Non:
			break ;
		case X:
			qpainter.setPen(QPen (Qt::blue, 3, SolidLine)) ;
			qpainter.drawLine(
				rect().x(), rect().y(),
				rect().x()+rect().width(), rect().y()+rect().height()) ;
			qpainter.drawLine(
				rect().x(), rect().y()+rect().height(),
				rect().x()+rect().width(), rect().y()) ;
			break;
		case O:
			qpainter.setPen(QPen (Qt::red, 3, SolidLine)) ;
			qpainter.drawEllipse(rect()) ;
			break ;
		case SmallCircle:
			qpainter.setBrush(Qt::red) ;		
			qpainter.drawEllipse(
				rect().x()+rect().width()*1/8, rect().y()+height()*1/8,
				rect().width()*6/8, rect().height()*6/8 ) ;
			break ;
		case Empty:
			/* qpainter.setBrush(Qt::gray) ;
			qpainter.drawEllipse(
				rect().x()+rect().width()*1/8, rect().y()+height()*1/8,
				rect().width()*6/8, rect().height()*6/8 ) ; */
			break ;
	}

	if (tiped) {
		qpainter.setBrush(Qt::green) ;
		qpainter.drawEllipse(
			rect().x()+rect().width()*3/8, rect().y()+height()*3/8,
			rect().width()*2/8, rect().height()*2/8 ) ;
	}
	
	if (selected) {
		qpainter.setBrush(Qt::yellow) ;
		qpainter.drawEllipse(
			rect().x()+rect().width()*1/8, rect().y()+height()*1/8,
			rect().width()*6/8, rect().height()*6/8 ) ;
	}


		
}

void KSquare::mousePressEvent (QMouseEvent *mouseevent)
{
		emit changeRequest(KSquare::Non, this) ;
}

void KSquare::setState (State state)
{
	KSquare::state = state ;
	update() ;
}

void KSquare::setBackground (Background background)
{
	KSquare::background = background ;
	/* update() ; */ /* Es necesario dibujar? */
}
