/***************************************************************************
                          cmudstream.h
                      -------------------
    description          : Class for wrapping telnet I/O
    begin                : Wed Dec 22 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMUDSTREAM_H
#define CMUDSTREAM_H

#include <qqueue.h>

#include "resource.h"
#include "ctelnet.h"
#include "kmudview.h"
#include "kmuddoc.h"
#include "cmudlog.h"
#include "ccharacterprofile.h"
#include "qdatetime.h"
#include "cmapwindow.h"

class KmudApp;
class CPluginManager;

/**
  *@author Stephan Uhlmann, Andre Alexander Bell
  * This class is for wrapping telnet I/O on order to have a centralized
  * place for processing/filtering these data
  */

class CMudStream : public QObject {
 Q_OBJECT

public:
	/** constructor */
	CMudStream(KmudApp* app);
	/** destructor */
	~CMudStream();

	/** set the entry for the current connected mud. Should be set to NULL
	    when not connected */
	void setCharDBEntry(CharDBEntry *e);

	/** sets the pointer to the mapper */
	void setMapper (CMapWindow *map);

	/** reset's the autologin */
	void reset ();


public slots:
	/** slot processing input to the mud */
	void slotProcessInput(QString);
	/** slot processing output from the mud */
	void slotProcessOutput(QString);

signals:
	/** emitted when input was processed */
	void processedInput();
	/** emitted when output was processed */
	void processedOutput();

private:

	KmudApp* kmudapp;

	CPluginManager* pluginmanager;

	/** Try to automagically log in */
	void autologin(QString output);

	/** telnet connection */
	CTelnet* connection;

	/** pointer to the Char DB entry */
	CharDBEntry *entry;
	/** pointers to the I/O processing classes */
	KmudView* view;
	/** the document */
	KmudDoc* doc;
	/** the log */
	CMudLog* log;

	/** The auto mapper */
	CMapWindow* mapper;
	/** The stack to hold directions so that then can be check to see if
	    They are a valid move */
	QQueue<QString> directionCmdQueue;

	////Filters////
	///////////////
	/** proccess speedwalking */
	void inSpdWalk(QString&, QString);
	/** proccess backslashes */
	void inBackslash(QString &);
	/** splits the input into pieces, using the separator-char */
	void inSeparator (QString & input, QString separatorChar);
	/** processes call to external commands */
	void inExternCommand (QString & input, QString externChar);
	/** has the loginname been sent */
	bool LoginHasBeenSent;
	/** has the password been sent */
	bool PasswordHasBeenSent;


	/** last time a trigger was activated */
	QTime triggerLoopLastTime;
	/** number of trigger events in a short time */
	int triggerLoopNum;
	/** true when triggers are in a loop */
	bool triggerLoop;
	/** true when we show the messagebox warning about the looping trigger */
	bool triggerLoopShowMessageBox;
	/** returns true when trigger seem to loop */
	bool triggerLoopDetect();

};

#endif
