/***************************************************************************
                          cmapzone.cpp
                      -------------------
    description          :
    begin                : Sun Dec 3 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmapzone.h"

#include <stdio.h>

CMapZone::CMapZone(QString zoneName,signed int x,signed int y, signed int level,CMapZone *mapZone)
{
	name = zoneName;
	setX(x);
	setY(y);
	mapLevel = level;
	zone = mapZone;
	mapLevelList.setAutoDelete(true);
	setSelected(false);
}

CMapZone::~CMapZone()
{
}

void CMapZone::paint(QPainter *p,CMapZone *currentZone)
{
	signed int y1,x1,x2,y2;
	
	x1 = getLowX();
	y1 = getLowY();
	x2 = getHiX();
	y2 = getHiY();	

	// Draw zone
	// Frist box of the zone
	p->setPen(white);
	p->drawLine(x1,y1,x1+8,y1);
	p->drawLine(x1,y1,x1,y1+8);
	p->setPen(black);
	p->drawLine(x1+1,y1+8,x1+8,y1+8);
	p->drawLine(x1+8,y1+1,x1+8,y1+8);	

	p->setBrush(QColor(192,192,192));
	p->setPen(QColor(192,192,192));
	p->drawRect(x1+1,y1+1,7,7);
	
	// Second box of the zone
	p->setPen(white);
	p->drawLine(x1+5,y1+5,x1+13,y1+5);
	p->drawLine(x1+5,y1+5,x1+5,y1+13);
	p->setPen(black);
	p->drawLine(x1+6,y1+13,x1+13,y1+13);
	p->drawLine(x1+13,y1+6,x1+13,y1+13);	
	
	p->setBrush(QColor(192,192,192));
	p->setPen(QColor(192,192,192));
	p->drawRect(x1+6,y1+6,7,7);

	// Third box of the zone
	p->setPen(white);
	p->drawLine(x1+9,y1+10,x1+17,y1+10);
	p->drawLine(x1+9,y1+10,x1+9,y1+17);
	p->setPen(black);
	p->drawLine(x1+10,y1+18,x1+17,y1+18);
	p->drawLine(x1+17,y1+11,x1+17,y1+18);	
	
	p->setBrush(QColor(192,192,192));
	p->setPen(QColor(192,192,192));
	p->drawRect(x1+10,y1+11,7,7);

	// If the room is selected then draw the selection indicator
	if (getSelected())
	{
		p->setPen(getSelectColour());
		p->setBrush(getSelectColour());
		p->drawRect(x2-3,y2-3,6,6);
	}	
}

void CMapZone::dragPaint(QPainter *p,int offsetx,int offsety,CMapZone *currentZone)
{
	signed int y1,x1,x2,y2;

	x1 = getLowX() + offsetx;
	y1 = getLowY() + offsety;
	x2 = getHiX() + offsetx;
	y2 = getHiY() + offsety;	

	p->setPen(getLowerColour());
	QBrush brush(getLowerColour());
	brush.setStyle(Dense3Pattern);

	// Draw zone
	// Frist box of the zone
	p->drawRect(x1,y1,8,8);
	
	// Second box of the zone
	p->drawRect(x1+5,y1+5,8,8);

	// Third box of the zone
	p->drawRect(x1+9,y1+10,8,8);
}

void CMapZone::lowerPaint(QPainter *p,CMapZone *currentZone)
{
	signed int y1,x1,x2,y2;

	x1 = getLowX()-5;
	y1 = getLowY()-5;
	x2 = getHiX()-5;
	y2 = getHiY()-5;	
	
	p->setPen(getLowerColour());
	QBrush brush(getLowerColour());
	brush.setStyle(Dense3Pattern);

	// Draw zone
	// Frist box of the zone
	p->drawRect(x1,y1,8,8);
	
	// Second box of the zone
	p->drawRect(x1+5,y1+5,8,8);

	// Third box of the zone
	p->drawRect(x1+9,y1+10,8,8);
}

void CMapZone::higherPaint(QPainter *p,CMapZone *currentZone)
{
	signed int y1,x1,x2,y2;
	
	x1 = getLowX()+5;
	y1 = getLowY()+5;
	x2 = getHiX()+5;
	y2 = getHiY()+5;	
	
	p->setPen(getHigherColour());
	QBrush brush(getHigherColour());
	brush.setStyle(Dense7Pattern);

	// Draw zone
	// Frist box of the zone
	p->drawRect(x1,y1,8,8);
	
	// Second box of the zone
	p->drawRect(x1+5,y1+5,8,8);

	// Third box of the zone
	p->drawRect(x1+9,y1+10,8,8);
}

CMapElement *CMapZone::copy(void)
{
	CMapZone *zone = new CMapZone(getName(),getX(),getY(),getLevel(),getZone());
	
	zone->setLevel(getLevel());
	zone->setX(getX());
	zone->setY(getY());
	zone->setLowHiX(getLowX(),getHiX());
	zone->setLowHiY(getLowY(),getHiY());
	zone->setSelected(getSelected());
	zone->setLowerColour(getLowerColour());
	zone->setHigherColour(getHigherColour());
	zone->setSelectColour(getSelectColour());
	zone->setName(getName());
	
	return zone;	
}

/** Used to set the name of the zone */
void CMapZone::setName (QString zoneName)
{ name = zoneName; }

/** Used get the zone name */
QString CMapZone::getName(void)
{ return name; }

/** Get a list of levels in the zone */
QList<CMapLevelList> *CMapZone::getLevels(void)
{ return &mapLevelList; }

void CMapZone::setEditMode(bool edit)
{
	editMode = false;
	if (edit)
		setSelected(false);
}

void CMapZone::setX(int x)
{
	xpos = x;	
	
	int newLoX = (x * ROOM_SIZE) - ROOM_SIZE + 1;
	int newHiX = (x * ROOM_SIZE) - 1;

	setLowHiX(newLoX,newHiX);
}

void CMapZone::setY(int y)
{
	ypos = y;
	
	int newLoY = (y * ROOM_SIZE) - ROOM_SIZE + 1;
	int newHiY = y * ROOM_SIZE-1;
	
	setLowHiY(newLoY,newHiY);
}

void CMapZone::moveBy(int x, int y)	
{
	setX(getX()+(x / ROOM_SIZE));
	setY(getY()+(y / ROOM_SIZE));
}

void CMapZone::read(KCMapFile* kcmfile)
{
  mapLevel = kcmfile->readNumEntry("level", 0);
  setX(kcmfile->readNumEntry("X", -1));
  setY(kcmfile->readNumEntry("Y", -1));

  name = kcmfile->readEntry("name", "");
}

void CMapZone::write(KCMapFile* kcmfile)
{
  kcmfile->writeEntry("level", mapLevel);
  kcmfile->writeEntry("X", getX());
  kcmfile->writeEntry("Y", getY());

  kcmfile->writeEntry("name", name);
  kcmfile->writeEntry("levels", mapLevelList.count());
}
