/***************************************************************************
                          kmudapplication.cpp
                      -------------------
    description          :
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmudapplication.h"
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <X11/Xlib.h>
#include <qkeycode.h>

KmudApplication::KmudApplication(int& argc, char** argv, const QString& rAppName)
	:KApplication (argc, argv, rAppName)
{
} // KMudApplication

KmudApplication::~KmudApplication()
{
}

/** catch the X11KeyEvents for the numeric keypad to implement the walking with the keypad */
bool KmudApplication::x11EventFilter (XEvent* e)
{
	bool b = false;
	if ((numpadMacros) && (e->type == KeyPress))
	{
		int keycode = XLookupKeysym(&e->xkey, 0);
		if ((keycode >= XK_KP_Multiply) && (keycode <= XK_KP_Equal))
		{
			if (focusWidget () != 0) sendEvent (focusWidget (), new QKeyEvent (Event_KeyPress, keycode, 0, 0));
			b = true;
		} // if
		else
		{
			keycode = XLookupKeysym(&e->xkey, 1);
			if ((keycode >= XK_KP_Multiply) && (keycode <= XK_KP_Equal))
			{
				if (focusWidget () != 0) sendEvent (focusWidget (), new QKeyEvent (Event_KeyPress, keycode, 0, 0));
				b = true;
			} // if
		} // else
	} // if
	if (!b) b = KApplication::x11EventFilter (e);
	return b;
} // x11EventFilter

/** are numpad macros enabled or disabled? */
bool KmudApplication::getNumpadMacros()
{
	return numpadMacros;
} // getNumpadMacros

/** enables or disables numpad-macros */
void KmudApplication::setNumpadMacros(bool b)
{
	numpadMacros = b;
} // setNumpadMacros
