/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for SKGWidgetCollectionDesignerPlugin component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestwidgetcollection.h"

#include <QIcon>

#include "skgwidgetcollectiondesignerplugin.h"
#include "skgzoomselector.h"
#include "skgwebview.h"
#include "skggraphicsscene.h"
#include "skgtestmacro.h"

void SKGTESTWidgetCollection::Test()
{
    SKGWidgetCollectionDesignerPlugin col(this);
    QList<QDesignerCustomWidgetInterface*> widgets = col.customWidgets();
    for (int i = 0; i < widgets.count(); ++i) {
        QDesignerCustomWidgetInterface* widget = widgets.at(i);
        QCOMPARE(widget != NULL, true);

        widget->isContainer();
        QCOMPARE(widget->isInitialized(), false);
        widget->initialize(NULL);
        QCOMPARE(widget->isInitialized(), true);
        widget->icon();
        QCOMPARE(widget->domXml() != "", true);
        QCOMPARE(widget->group(), QString("SKG Widgets"));
        QCOMPARE(widget->includeFile() != "", true);
        QCOMPARE(widget->name() != "", true);
        QCOMPARE(widget->toolTip() != "", true);
        QCOMPARE(widget->whatsThis() != "", true);
        QCOMPARE(widget->createWidget(NULL) != NULL, true);
    }

    // Test zoom
    SKGZoomSelector zoom;
    zoom.zoomIn();
    zoom.zoomOut();
    zoom.initializeZoom();

    // Test web view
    SKGWebView web;
    web.onZoomIn();
    web.onZoomOut();
    web.exportInFile(SKGTest::getTestPath("OUT") % "/skgtestwidgetcollection/export.pdf");
    web.exportInFile(SKGTest::getTestPath("OUT") % "/skgtestwidgetcollection/export.html");
    web.exportInFile(SKGTest::getTestPath("OUT") % "/skgtestwidgetcollection/export.jpg");

    SKGGraphicsScene graphScene;
}

QTEST_MAIN(SKGTESTWidgetCollection)

