/**************************************************************************
        kstlabeldialog_i.h - source file: inherits designer dialog
                             -------------------
    begin                :  2003
    copyright            : (C) 2003 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qfontdatabase.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qstring.h>
#include <qwidget.h>

#include <kfontcombo.h>
#include <klineedit.h>
#include <knuminput.h>
#include <kmdimainfrm.h>

#include "kstdatacollection.h"
#include "kstlabeldialog_i.h"
#include "scalarselector.h"
#include "kstviewwindow.h"
#include "kst.h"

KstLabelDialogI::KstLabelDialogI(QWidget *parent, const char* name, bool modal,
                                 WFlags fl)
: KstLabelDialog(parent, name, modal, fl) {
  _x = _y = 0.0;
  _i_plot = 0;

  FontComboBox->setCurrentFont(this->font().family());

  connect(Apply, SIGNAL(clicked()), this, SLOT(apply()));
  connect(OK, SIGNAL(clicked()), this, SLOT(ok()));
  connect(Delete, SIGNAL(clicked()), this, SLOT(deleteL()));
}

KstLabelDialogI::~KstLabelDialogI() {
}

void KstLabelDialogI::showI(Kst2DPlotPtr plot, int i_label, double in_x, double in_y) {
  _x = in_x;
  _y = in_y;
  _i_plot = plot;
  if (i_label < 0) {
    _editing = false;
    _i_label = 0;
    LabelText->setText(QString::null);
  } else if (plot->labelList.count() > (unsigned) i_label) {
    _editing = true;
    _i_label = i_label;
  } else {
    _editing = false;
    _i_label = 0;
  }

  updateI();
  show();
}

void KstLabelDialogI::updateI() {
  _scalars->update();

  if (_editing && _i_plot) {
    if ((int)_i_plot->labelList.count() <= _i_label) {
      _editing = false;
      _i_label = 0;
    } else {
      KstLabel *label = _i_plot->labelList.at(_i_label);
      LabelText->setText(label->text());
      FontSize->setValue(label->size());
      switch (label->justification()) {
        case LxBy:
          LeftJustify->setChecked(true);
          break;
        case CxBy:
          CenterJustify->setChecked(true);
          break;
        case RxBy:
          RightJustify->setChecked(true);
          break;
        default:
          LeftJustify->setChecked(true);
      }
      FontComboBox->setCurrentFont(label->fontName());
      Rotation->setValue((int)label->rotation());
    }
  } else {
    _editing = false;
  }
}

void KstLabelDialogI::apply() {
  //updateI();
  if (_editing) {
    applyEdits();
  } else{
    applyAsNew();
  }

  KMdiChildView *c = KstApp::inst()->activeWindow();
  if (c) {
    static_cast<KstViewWindow*>(c)->view()->paint(P_PLOT);
  }

  emit applied();
}

void KstLabelDialogI::applyAsNew() {
  KstLabel *new_label;
  KstJustifyType J;

  if (LeftJustify->isChecked()) {
    J = LxBy;
  } else if (CenterJustify->isChecked()) {
    J = CxBy;
  } else {
    J = RxBy;
  }

  new_label = new KstLabel(LabelText->text(), J,
                           (float) Rotation->value(), _x, _y, false);
  new_label->setFontName(FontComboBox->currentText());
  new_label->setSize(FontSize->value()); // FIXME: spin box name is wrong

  _i_plot->labelList.append(new_label);
  _i_label = _i_plot->labelList.count() - 1;
  _editing = true;
  _i_plot->update();
}

void KstLabelDialogI::applyEdits() {
  if (_i_plot) {
    if ((int)_i_plot->labelList.count() <= _i_label) {
    // some surprising badness...  shouldn't happen - so just bail
      _editing = false;
      _i_label = 0;
      return;
    } else {
      KstLabel *label = _i_plot->labelList.at(_i_label);
      KstJustifyType J;

      if (LeftJustify->isChecked()) {
        J = LxBy;
      } else if (CenterJustify->isChecked()) {
        J = CxBy;
      } else {
        J = RxBy;
      }

      label->setText(LabelText->text());
      label->setJustification(J);
      label->setSize(FontSize->value());
      label->setFontName(FontComboBox->currentText());
      label->setRotation((float)Rotation->value());
    }
    _i_plot->update();
  }
}

void KstLabelDialogI::ok() {
  apply();
  close();
}

void KstLabelDialogI::deleteL() {
  if (!_editing) {
    close();
    return;
  }

  if (_i_plot) {
    if ((int)_i_plot->labelList.count() <= _i_label) {
      // some surprising badness...  shouldn't happen - so just bail
      _editing = false;
      _i_label = 0;
      close();
      return;
    } else {
      _i_plot->labelList.remove(_i_label);
      emit applied();
    }
    _i_plot->update();
  }
  _editing = false;
  close();
}


#include "kstlabeldialog_i.moc"
// vim: ts=2 sw=2 et
