/***************************************************************************
                          textitem.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <ksimpleconfig.h>
#include "kgraph.h"
#include "textitem.h"
#include "utils.h"
#ifndef KPL_CLASSES_ONLY
#include <qlistview.h>
#include "textdlg.h"
#endif

TextItem::TextItem() : iAlign(1), dir(0.0)
{
}

TextItem::TextItem(KplNamespace::AutoStruct* aut) :
 DecoItem(aut), iAlign(1), dir(0.0)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto;
}

TextItem::TextItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut) :
 DecoItem(plo, aut)
{
  iAlign = plo->readNumEntry("align", 1);
  dir = plo->readDoubleNumEntry("dir");
  s = plo->readEntry("s", "");
}

TextItem::TextItem(bool act, int iAl, const QString& col,
                   double x, double y, double d, double relSize,
                   const QString& text) :
 DecoItem(act, col, x, y, relSize), iAlign(iAl), dir(d), s(text)
{
}

TextItem::~TextItem()
{
}

KplItem::ItemTypes TextItem::iType() const
{
  return Text;
}

void TextItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColFrame(color);
    g->setDir(dir);
    double sav = g->setRelSize(relsiz);
    g->textcm(s, x0, y0, iAlign, g->type() ? 0 : &bRect);
    g->setRelSize(sav);
    g->setDir(0.0);
  }
}

#ifndef KPL_CLASSES_ONLY
void TextItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const
{
  plo->writeEntry("Type", "TEXTITEM");
  DecoItem::writePlo(plo, url, abs, m);
  plo->writeEntry("align", iAlign);
  plo->writeEntry("dir", dir);
  plo->writeEntry("s", s);
}

void TextItem::setText(QListViewItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Text"));
  it->setText(2, "\"" + s + "\", x = " + QString::number(x0) +
              " cm, y = " + QString::number(y0) + " cm");
}

int TextItem::editItem(QWidget* parent, KplDoc* m, int)
{
  TextDlg dlg(parent, m, this);
  return dlg.exec();
}
#endif

KplItem* TextItem::copy() const
{
  return new TextItem(*this);
}
