/***************************************************************************
                          imagedlg.cpp  -  description
                             -------------------
    begin                : Don Jun 5 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kfiledialog.h>
#include <kimageio.h>
#include <kmessagebox.h>
#include <klocale.h>
#include "imagedlg.h"
#include "imageitem.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "utils.h"

ImageDlg::ImageDlg(QWidget* _parent, KplDoc* model, ImageItem* _ad) :
 KDialogBase(Plain, i18n("Image"), Help | Ok | Apply | Cancel, Ok, _parent, 0,
             true, true), m(model), ad(_ad)
{
  QFrame* frame = plainPage();
  QGridLayout* grid = new QGridLayout(frame, 4, 7, 0, spacingHint());
  grid->addWidget(new QLabel(i18n("File"), frame), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout(spacingHint());
  hbox->addWidget(fileName = new QLineEdit(ad->url.isLocalFile() ?
                                           ad->url.path() : ad->url.url(),
                                           frame));
  grid->addMultiCellLayout(hbox, 0, 0, 1, 5);
  QPushButton* b = new QPushButton("...", frame);
  b->setFixedWidth(28);
  grid->addWidget(b, 0, 6);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel("x0", frame), 1, 0);
  grid->addWidget(ex0 = new KplDoubleEdit(ad->x0, -200.0, 200.0, frame), 1, 1);
  grid->addWidget(new QLabel("cm", frame), 1, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 1, 3);
  grid->addWidget(new QLabel("y0", frame), 1, 4);
  grid->addWidget(ey0 = new KplDoubleEdit(ad->y0, -200.0, 200.0, frame), 1, 5);
  grid->addWidget(new QLabel("cm", frame), 1, 6);
  grid->addWidget(new QLabel(i18n("x scaling"), frame), 2, 0);
  grid->addWidget(efx = new KplDoubleEdit(100.0 * ad->fx, 0.0, 800.0, frame,
                                          'f', 1), 2, 1);
  grid->addWidget(new QLabel("%", frame), 2, 2);
  grid->addWidget(new QLabel(i18n("y scaling"), frame), 2, 4);
  grid->addWidget(efy = new KplDoubleEdit(100.0 * ad->fy, 0.0, 800.0, frame,
                                          'f', 1), 2, 5);
  grid->addWidget(new QLabel("%", frame), 2, 6);
  grid->addMultiCellLayout(hbox = new QHBoxLayout(), 3, 3, 1, 6);
  hbox->addWidget(isotropic = new QCheckBox(i18n("Maintain aspect ratio"),
                                            frame));
  hbox->addItem(new QSpacerItem(10, 10, QSizePolicy::Expanding));
  connect(isotropic, SIGNAL(toggled(bool)), SLOT(slotAspect(bool)));
  isotropic->setChecked(ad->fx == ad->fy);
  Utils::setSize(this, "ImageDialog");
  setHelp("SEC-IMAGE");
}

ImageDlg::~ImageDlg()
{
  Utils::saveSize(this, "ImageDialog");
}

void ImageDlg::getValues(bool ok)
{
  KURL u = fileName->text();
  QString fn;
  double x1, x2, y1, y2;
  if (u.isLocalFile() ? Utils::boundingBox(u, fn, &x1, &y1, &x2, &y2) :
                        (KImageIO::mimeType(u.path()) == "image/x-eps")) {
    ad->url = u;
    ad->setPos(ex0->value(), ey0->value());
    ad->fx = 0.01 * efx->value();
    ad->fy = isotropic->isChecked() ? ad->fx : (0.01 * efy->value());
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
  } else {
    KMessageBox::sorry(this, i18n("not an EPS file!"));
    return;
  }
}

void ImageDlg::slotFile()
{
  KURL url = KFileDialog::getOpenURL(m->currentDir(),
    "*.eps *.EPS *.epsi *.EPSI *.epsf *.EPSF\n*");
  if (!url.isEmpty()) {
    fileName->setText(url.isLocalFile() ? url.path() : url.url());
  }
}

void ImageDlg::slotAspect(bool iso)
{
  if (iso)
    efy->setValue(efx->value());
  efy->setDisabled(iso);
}

void ImageDlg::slotOk()
{
  getValues(true);
}

void ImageDlg::slotApply()
{
  getValues(false);
}
