/***************************************************************************
                          legenditem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Tue Aug 31 1999
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <ksimpleconfig.h>
#include "kgraph.h"
#include "legenditem.h"
#include "utils.h"
#ifndef KPL_CLASSES_ONLY
#include <qlistview.h>
#include "legenddlg.h"
#endif

LegendItem::LegendItem() : symb(0), coltext(0),
 xtext(0.0), ytext(0.0), symbSize(1.0)
{
}

LegendItem::LegendItem(KplNamespace::AutoStruct* aut) :
 DecoItem(aut), symb(aut->autoSymb), coltext(aut->colFrame), symbSize(1.0)
{
  color = aut->colData;
  double dx = aut->xlAuto / 15.0;
  x0 = aut->x0Auto + dx;
  y0 = aut->y0Auto + aut->ylAuto - (++aut->nyLeg) * dx;
  xtext = dx;
  ytext = -0.18 * dx;
}

LegendItem::LegendItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut) :
 DecoItem(plo, aut)
{
  symb = plo->readNumEntry("symb", aut->autoSymb);
  QString s1 = plo->readEntry("coltext", "");
  coltext = s1.isEmpty() ? aut->colFrame : KplGraph::rgbQt(s1);
  double dx = aut->xlAuto / 15.0;
  xtext = plo->readDoubleNumEntry("xtext", dx);
  ytext = plo->readDoubleNumEntry("ytext", -0.18 * dx);
  symbSize = plo->readDoubleNumEntry("symbsize", 1.0);
  s = plo->readEntry("s", "");
}

LegendItem::LegendItem(bool act, int sym, const QString& colSymb,
                       const QString& colText, double x, double y,
                       double xoff, double yoff, double relSize,
                       const QString& text) :
 DecoItem(act, colSymb, x, y, relSize), symb(sym), xtext(xoff), ytext(yoff),
 symbSize(1.0), s(text)
{
  coltext = KplGraph::rgbQt(colText);
}

LegendItem::~LegendItem()
{
}

KplItem::ItemTypes LegendItem::iType() const
{
  return Legend;
}

void LegendItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColData(color);
    g->setSymbol(symb);
    int n;
    double xa[2], ya[2];
    if (symb > 0) {
      g->cm2r(x0 - 0.4 * xtext, y0, 1.0, 1.0, &xa[0], &ya[0]);
      g->cm2r(x0 + 0.4 * xtext, y0, 1.0, 1.0, &xa[1], &ya[1]);
      n = 2;
      g->resetDash();
    } else {
      g->cm2r(x0, y0, 1.0, 1.0, &xa[0], &ya[0]);
      n = 1;
    }
    double sav = g->relSize();
    g->setRelSize(sav * symbSize);
    g->plArray(xa, ya, 1.0, 1.0, n, false, false);
    g->resetDash();
    g->setColFrame(coltext);
    g->setRelSize(relsiz);
    g->textcm(s, x0 + xtext, y0 + ytext, 1, g->type() ? 0 : &bRect);
    if (!g->type()) {
      KGraph* gr = (KGraph*) g;
      bRect = bRect.unite(QRect(gr->fromcm(x0 - 0.4 * xtext, y0 + 0.1),
                                gr->fromcm(x0 + 0.4 * xtext, y0 - 0.1)));
    }
    g->setRelSize(sav);
  }
}

#ifndef KPL_CLASSES_ONLY
void LegendItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                          KplDoc* m) const
{
  plo->writeEntry("Type", "LEGENDITEM");
  DecoItem::writePlo(plo, url, abs, m);
  plo->writeEntry("symb", symb);
  plo->writeEntry("coltext", QString::number(KplGraph::rgbQt1(coltext), 16));
  plo->writeEntry("xtext", xtext);
  plo->writeEntry("ytext", ytext);
  plo->writeEntry("symbsize", symbSize);
  plo->writeEntry("s", s);
}

void LegendItem::setText(QListViewItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Legend"));
  KGraph g;
  it->setPixmap(2, g.pixmap(symb, color));
  it->setText(2, "\"" + s + "\", x = " + QString::number(x0) +
              " cm, y = " + QString::number(y0) + " cm");
}

int LegendItem::editItem(QWidget* parent, KplDoc* m, int)
{
  LegendDlg dlg(parent, m, this);
  return dlg.exec();
}
#endif

KplItem* LegendItem::copy() const
{
  return new LegendItem(*this);
}
