/***************************************************************************
                          kmudview.cpp
                      -------------------
    description          : View Class (Main View)
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qmessagebox.h>
#include "kmudview.h"


KmudView::KmudView(KApplication* a,KmudDoc* doc,QWidget *parent)
	: QWidget(parent){

	document = doc;
	
	///////////////////////////////////////////////////////////////////
	// setup my widgets

	output = new CMudView(document, this,"output");
	output->setFont(QFont("courier",12));
	output->setBackgroundMode(NoBackground);

	splitMode=false;
	splitoutput = new CMudView(document, this,"output");
	splitoutput->setFont(QFont("courier",12));
	splitoutput->setBackgroundMode(NoBackground);
	splitoutput->setScrollBarsVisible(false);
	splitoutput->hide();

	input = new CMudLineEdit(document, this,"input");
	input->setBackgroundMode(PaletteBackground);
	input->setFocus();
	input2 = new CMudLineEdit(document, this,"input2");
	input2->setBackgroundMode(PaletteBackground);

	setLocalEchoColor(QColor(0,0,0));

	setLocalEcho(true);
	setLocalEchoMode(2);
	setInputEcho(true);
	setInputEchoMode(2);

	QObject::connect(input, SIGNAL(textSend(QString)), SLOT(slotInputReturnPressed(QString)));
	QObject::connect(input2, SIGNAL(textSend(QString)), SLOT(slotInputReturnPressed(QString)));
	QObject::connect(input, SIGNAL(scrollKeyPressed(QKeyEvent *)),output,SLOT(slotScrollKey(QKeyEvent *)));
	QObject::connect(input2,SIGNAL(scrollKeyPressed(QKeyEvent *)),output,SLOT(slotScrollKey(QKeyEvent *)));
	QObject::connect(input, SIGNAL(macroPressed(QString)), SLOT(slotMacroPressed(QString)));
	QObject::connect(input2,SIGNAL(macroPressed(QString)), SLOT(slotMacroPressed(QString)));
	QObject::connect(output,SIGNAL(vSliderAtBottomChanged(bool)), SLOT(slotChangeSplitMode(bool)));
}

KmudView::~KmudView(){
	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()
}


void KmudView::setOutputDefaultForegroundColor(QColor fgc)
{
	output->setDefaultForeground(fgc);
	splitoutput->setDefaultForeground(fgc);
}

QColor KmudView::getOutputDefaultForegroundColor()
{
	return output->getDefaultForeground();
}

void KmudView::setOutputDefaultBackgroundColor(QColor bgc)
{
	output->setDefaultBackground(bgc);
	splitoutput->setDefaultBackground(bgc);
}

QColor KmudView::getOutputDefaultBackgroundColor()
{
	return output->getDefaultBackground();
}

void KmudView::setOutputDefaultFont( QFont font )
{
	output->setDefaultFont(font);
	splitoutput->setDefaultFont(font);
}

QFont KmudView::getOutputDefaultFont()
{
	return output->getDefaultFont();
}


void KmudView::setOutputActualForegroundColor(QColor fgc)
{
	output->setActualForeground(fgc);
	splitoutput->setActualForeground(fgc);
}

QColor KmudView::getOutputActualForegroundColor()
{
	return output->getActualForeground();
}

void KmudView::setOutputActualBackgroundColor(QColor bgc)
{
	output->setActualBackground(bgc);
	splitoutput->setActualBackground(bgc);
}

QColor KmudView::getOutputActualBackgroundColor()
{
	return output->getActualBackground();
}

void KmudView::setOutputActualFont( QFont font )
{
	output->setActualFont(font);
	splitoutput->setActualFont(font);
}

QFont KmudView::getOutputActualFont()
{
	return output->getActualFont();
}



void KmudView::setInterpretType(int i)
{
	output->setInterpretType(i);
	splitoutput->setInterpretType(i);
}
int KmudView::getInterpretType()
{ 
	return output->getInterpretType(); 
}

/** for foreground colors */
void KmudView::setOutputANSIColor(int ANSIColor, QColor color)
{
  output->setOutputANSIColor(ANSIColor, color);
  splitoutput->setOutputANSIColor(ANSIColor, color);
}

QColor KmudView::getOutputANSIColor(int ANSIColor)
{
  return output->getOutputANSIColor(ANSIColor);
}

/** for background colors */
void KmudView::setOutputBgColor(int BgColor, QColor color)
{
  output->setOutputBgColor(BgColor, color);
  splitoutput->setOutputBgColor(BgColor, color);
}

QColor KmudView::getOutputBgColor(int BgColor)
{
  return output->getOutputBgColor(BgColor);
}

QColor KmudView::getDebugHighlightColor()
{
	return output->getDebugHighlightColor();
}

void KmudView::setDebugHighlightColor(QColor color)
{
	output->setDebugHighlightColor(color);
	splitoutput->setDebugHighlightColor(color);
}


void KmudView::setInputFont( QFont font )
{
	input->setFont(font);
	input2->setFont(font);
}

QFont KmudView::getInputFont()
{
	return input->font();
}

void KmudView::setInputBackgroundColor(QColor bgc)
{
// QLineEdit will only set the frame to bgc not the background itself,
// the real background will be set either to white (light bgc) or black (dark bgc)
// so to avoid a black frame on a black background set it to grey in this special case
// sorry, but dont know what QLineEdit is doing there %-|
	if (bgc==QColor(0,0,0))
		bgc=QColor(32,32,32);
	input->setPalette(QPalette(bgc));
	input2->setPalette(QPalette(bgc));
}

QColor KmudView::getInputBackgroundColor()
{
	return input->backgroundColor();
}

void KmudView::setLocalEchoColor(QColor c)
{
	localEchoColor=c;
}

QColor KmudView::getLocalEchoColor()
{
	return localEchoColor;
}

void KmudView::recalcWidgetSizes()
{
	int i=(input->fontMetrics()).height()+8;
	int splitSize=height() / 4;
	int scrollBarWidth=output->getVScrollBarWidth();
	int scrollBarHeight=output->getHScrollBarHeight();

	if (splitMode)
		splitoutput->show();
	else
		splitoutput->hide();

	if (input2->isVisible())
	{
		output->setGeometry(0,0,width(),height()-i-i);
		splitoutput->setGeometry(0,height()-i-i-splitSize-scrollBarHeight,width()-scrollBarWidth,splitSize);
		input->setGeometry(0,height()-i-i,width(),i);
		input2->setGeometry(0,height()-i,width(),i);
	} else {
		output->setGeometry(0,0,width(),height()-i);
		splitoutput->setGeometry(0,height()-i-splitSize-scrollBarHeight,width()-scrollBarWidth,splitSize);
		input->setGeometry(0,height()-i,width(),i);
		input2->setGeometry(0,height()-i,width(),i);
	}

}

void KmudView::resizeEvent( QResizeEvent * )
{
	///////////////////////////////////////////////////////////////////
	// refresh Geometry settings, if view resized
	
	recalcWidgetSizes();

}

QString KmudView::displayMudOutput(QString buf, bool noANSIColors)
{
	QString returnString;

	returnString = output->append(buf,output->getDefaultForeground(),output->getDefaultBackground(),output->getDefaultFont(),noANSIColors);
	splitoutput->append(buf,output->getDefaultForeground(),output->getDefaultBackground(),output->getDefaultFont(),noANSIColors);

	return returnString;
}

QString KmudView::resolveAliases(QString s)
{
	QString left,mid,right,result;
	AliasEntry* alias;
	CCharacterProfile* prof;
	int pos,loop;
	bool aliased;
	bool isWord;

  if (document->getAliasesDisabled())
  {
    return s;
  }
	
	prof = document->getCharacterProfile(document->getCurrentCharacterID());
	if (prof)
	{
		/** Parse semi-colons */
		right = s;
		result = "";

		/** This code parses input, replaces seperators (";") with \n
		 ** and replaces aliases with their definitions.
		 **/
		loop=0;
		while ((right != "") && (loop<1000))
		{
			// split by seperator into substrings, handle one substring (left) per loop
			pos=right.find(separator);

			if ((pos>=0) && (separator!=""))
			{
				left=right.left(pos); // left from seperator
				mid=separator; // the seperator himself, yeah
				right=right.right(right.length()-left.length()-mid.length()); // the rest
			}
			else
			{
				left=right;
				mid="";
				right="";
			}

			// parse for aliases
			aliased=false;
			alias = prof->firstAlias();
			while ((alias != NULL) && (aliased==false))
			{

				pos=left.find(alias->name,0);
				while (pos>=0)
				{

					// only accept aliases as one or more words
					isWord=true; // assume it is a word
					// it's not a word when not at beginning and not a space before
					if (pos>0)
						if (left.at(pos-1)!=' ')
							isWord=false;
					// it's not a word when not at end and not a space after
					if (pos+alias->name.length()<left.length())
						if (left.at(pos+alias->name.length())!=' ')
							isWord=false;

					if (isWord)
					{
						// prepend definition to right -> parse again in
						// next loop (could contain more aliases)
						left=left.replace(pos,alias->name.length(),alias->definition);//+mid+right;
						aliased=true;
						pos=left.find(alias->name,pos+alias->definition.length());
					}
					else
						pos=left.find(alias->name,pos+alias->name.length());
				}

				if (aliased)
	        right=left+mid+right;

				alias = prof->nextAlias();
			}

			// if no more aliases, append to resulting string
			if (aliased==false)
			{
				result.append(left);
				result.append(mid);
			}
			loop++;
		} // while
    	
		// oops, loop in the aliases detected
		if (loop>=1000)
		{
			QMessageBox::warning(this, i18n("Alias loop detected"), i18n("Your aliases were looping.\nLast input ignored."));
		}
	}
	else
		result=s.copy();


	return result;
}

void KmudView::slotMacroPressed(QString macro)
{
	emit enteredInput(resolveAliases(macro)+"\n");
}

void KmudView::slotInputReturnPressed(QString s)
{
	emit enteredInput(resolveAliases(s)+"\n");
}


QString KmudView::slotAppendToOutput(QString s)
{
	QString returnString;

	if ((localEchoMode==1) || ((localEcho==true) && (localEchoMode==2))) {
		returnString = output->append(s,localEchoColor,output->getDefaultBackground(),output->getDefaultFont());
		splitoutput->append(s,localEchoColor,output->getDefaultBackground(),output->getDefaultFont());
	} else {
		if (localEchoSuppressNewline==false)
		{
			returnString = output->append("\n",localEchoColor,output->getDefaultBackground(),output->getDefaultFont());
			splitoutput->append("\n",localEchoColor,output->getDefaultBackground(),output->getDefaultFont());
		}
		else // suppress newline (i.e. append nothing)
		{
			returnString="";
		}
	}
	return returnString;
}

void KmudView::slotMudClosed()
{
	output->append(i18n("\nConnection closed by foreign host.\n"),output->getDefaultForeground(),output->getDefaultBackground(),output->getDefaultFont());
	splitoutput->append(i18n("\nConnection closed by foreign host.\n"),output->getDefaultForeground(),output->getDefaultBackground(),output->getDefaultFont());
}


bool KmudView::getLocalEcho()
{
	return localEcho;
}

void KmudView::setLocalEcho(bool b)
{
	localEcho=b;
}

int KmudView::getLocalEchoMode()
{
	return localEchoMode;
}

void KmudView::setLocalEchoMode(int i)
{
	localEchoMode=i;
}

bool KmudView::getLocalEchoSupressNewline()
{
	return localEchoSuppressNewline;
}

void KmudView::setLocalEchoSupressNewline(bool b)
{
	localEchoSuppressNewline=b;
}


bool KmudView::getInputEcho()
{
	return inputEcho;
}

void KmudView::setInputEcho(bool b)
{
	inputEcho=b;

	if ((inputEchoMode==0)||((inputEchoMode==2)&&(b==false))) {
		input->setEchoMode(QLineEdit::NoEcho);
		input2->setEchoMode(QLineEdit::NoEcho);
	} else  {
		input->setEchoMode(QLineEdit::Normal);
 		input2->setEchoMode(QLineEdit::Normal);
	}
}

int KmudView::getInputEchoMode()
{
	return inputEchoMode;
}

void KmudView::setInputEchoMode(int i)
{
	inputEchoMode=i;
	
	if ((i==0)||((i==2)&&(inputEcho==false))){
		input->setEchoMode(QLineEdit::NoEcho);
		input2->setEchoMode(QLineEdit::NoEcho);
	} else {
		input->setEchoMode(QLineEdit::Normal);
		input2->setEchoMode(QLineEdit::Normal);
	}
}

void KmudView::setAltInput(bool b)
{
	if (b)
	{
		input2->show();
		resizeEvent(NULL);
	}
	else
	{
		input2->hide();
		resizeEvent(NULL);
	}
}

void KmudView::setMaxHistoryLines(int l)
{
	input->setMaxHistoryLines(l);
	input2->setMaxHistoryLines(l);
}


void KmudView::setMaxMudViewLines(int l)
{
	output->setMaxLines(l);
}

void KmudView::setSharedInputHistory(bool b)
{
	if (b==false)
	{
		input2->setHistory(NULL);
	}
	else
	{
		input2->setHistory(input->getHistory());
	}

}

bool KmudView::getKeepLastInput()
{
	return input->getKeepLastInput();
}

void KmudView::setKeepLastInput(bool b)
{
	input->setKeepLastInput(b);
	input2->setKeepLastInput(b);
}

bool KmudView::getSelectAllOnFocus()
{
	return input->getSelectAllOnFocus();
}

void KmudView::setSelectAllOnFocus(bool b)
{
	input->setSelectAllOnFocus(b);
	input2->setSelectAllOnFocus(b);
}

void KmudView::setSeparator(QString s) {
	separator = s;
}

QString KmudView::getSeparator() {
	return separator;
}

void KmudView::setAutoReconnect(bool b)
{
	autoReconnect = b;
}

bool KmudView::getAutoReconnect()
{
	return autoReconnect;
}

void KmudView::setAutoTime(unsigned int t)
{
	autoTime = t;
}

unsigned int KmudView::getAutoTime()
{
	return autoTime;
}

bool KmudView::getUseBeep() {
	return output->getUseBeep();
}

void KmudView::setUseBeep(bool u) {
	output->setUseBeep(u);
}

void KmudView::slotChangeSplitMode(bool on)
{
	splitMode=on;
	recalcWidgetSizes();
	repaint();
}

/** returns the Inputline */
CMudLineEdit* KmudView::getInput ()
{
	return input;
} // getInput



/** returns whether special chars are enabled or not */
bool KmudView::getEnableSpecialChars()
{
	return enableSpecialChars;
}

/** sets whether special chars are enabled or not */
void KmudView::setEnableSpecialChars(bool b)
{
	enableSpecialChars=b;
}

/** returns the character, that starts a speedwalking sequence */
QString KmudView::getSpeedwalkingChar ()
{
	return speedwalkingChar;
} // getSpeedwalkingChar

/** sets the character, that starts a speedwalking-sequence */
void KmudView::setSpeedwalkingChar (QString s)
{
	speedwalkingChar = s;
} // setSpeedwalkingChar

/** returns the ExternCommandChar */
QString KmudView::getExternChar()
{
	return externCommandChar;
} // getExternChar

/** set's the external command char */
void KmudView::setExternChar (QString externChar)
{
	externCommandChar = externChar;
} // setExternChar

