/***************************************************************************
                          dlgmultilineinput.cpp
                      -------------------
    description          :
    begin                : Sat Jan 8 2000                                           
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgmultilineinput.h"
#include <kapp.h>
#include <kfiledialog.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qregexp.h>


DlgMultiLineInput::DlgMultiLineInput(QWidget *parent, const char *name) : QDialog(parent,name,false)
{
	setCaption(i18n("Kmud - Multiline Input"));

	lastDirPath="";

	initDialog();
	input_MultiLineEdit->setFocus();

	connect( send_Button, SIGNAL(clicked()), SLOT(sendButtonClicked()) );
	connect( insertFile_Button, SIGNAL(clicked()), SLOT(insertFileButtonClicked()) );
	connect( clear_Button, SIGNAL(clicked()), input_MultiLineEdit, SLOT(clear()) );
	connect( close_Button, SIGNAL(clicked()), SLOT(closeButtonClicked()) );

}

DlgMultiLineInput::~DlgMultiLineInput(){
}

void DlgMultiLineInput::sendButtonClicked()
{
	QString s = input_MultiLineEdit->text();
	emit sendText(s.replace(QRegExp("\\"),"\\\\")+"\n");
}

void DlgMultiLineInput::insertFileButtonClicked()
{
	KFileDialog filedialog("");
	QString filename, text;
	QFile file;
	QTextStream stream;
	int x,y;

	filename=filedialog.getOpenFileName(lastDirPath);

	if ((filename) && (filename!=""))
	{
		file.setName(filename);
		QFileInfo fileinfo=QFileInfo(file);
		if ((fileinfo.isFile()) && (file.open(IO_ReadOnly)==true))
		{
			lastDirPath=fileinfo.dirPath(true);
			if (input_MultiLineEdit->text()=="") input_MultiLineEdit->insertLine("");
			stream.setDevice(&file);
			input_MultiLineEdit->cursorPosition(&y,&x);
			while (!stream.eof())
			{
				text = stream.readLine(); // does not contain trailing newline...
				if (x>0)
				{
					x=9999; text="\n"+text;
				}
				else
				{
					x=0;text=text+"\n";
				}
				input_MultiLineEdit->insertAt(text,y,x);
				y++;

				input_MultiLineEdit->setCursorPosition(y,x);
			}
			file.close();
		}
		else
		{
			QMessageBox errorbox1("Kmud",QString(i18n("Error opening file "))+filename+i18n(" for reading."),QMessageBox::Warning,
					QMessageBox::Ok | QMessageBox::Default,0,0,0,"ErrorOpenFileMessageBox",TRUE,0);
			errorbox1.exec();
		}
	}
}

void DlgMultiLineInput::closeButtonClicked()
{
	emit dialogClosed();
}

void DlgMultiLineInput::resizeEvent(QResizeEvent* e)
{

	int buttonX=this->width()/2;
	if (buttonX<0) buttonX=0;

	input_MultiLineEdit->setGeometry(10,10,this->width()-20,this->height()-60);
	send_Button->setGeometry(buttonX-240,this->height()-40,100,30);
	insertFile_Button->setGeometry(buttonX-120,this->height()-40,100,30);
	clear_Button->setGeometry(buttonX+20,this->height()-40,100,30);
	close_Button->setGeometry(buttonX+140,this->height()-40,100,30);

	QDialog::resizeEvent(e);

}

void DlgMultiLineInput::closeEvent(QCloseEvent* e)
{
	emit dialogClosed();
}
