/***************************************************************************
                          dlgmapoptionspreferences.h
                      -------------------
    description          : Preferences Dialog Class
    begin                : Fri Apr 28 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGMAPOPTIONSPREFERENCES_H
#define DLGMAPOPTIONSPREFERENCES_H

#include <qtabdialog.h>



#include "dlgmapoptionsdirections.h"
#include "dlgmapoptionscolours.h"
#include "dlgmapoptionsmisc.h"
#include "dlgmapoptionsspeedwalk.h"

/**The preferences for the auto mapper
  *@author John-Paul Stanford
  */

class DlgMapOptionsPreferences : public QTabDialog {
	Q_OBJECT
public:
	/** constructor */
	DlgMapOptionsPreferences(QWidget *parent=0, const char *name=0);
	/** destructor */
	~DlgMapOptionsPreferences();

	// Used to set the directions
	void setNorth(QString direction);
	void setNorthEast(QString direction);
	void setEast(QString direction);
	void setSouthEast(QString direction);
	void setSouth(QString direction);
	void setSouthWest(QString direction);
	void setWest(QString direction);
	void setNorthWest(QString direction);
	void setUp(QString direction);
	void setDown(QString direction);

	// Used to get the directions
	QString getNorth(void);
	QString getNorthEast(void);
	QString getEast(void);
	QString getSouthEast(void);
	QString getSouth(void);
	QString getSouthWest(void);
	QString getWest(void);
	QString getNorthWest(void);
	QString getUp(void);
	QString getDown(void);

	// Used to set the colours
	void setBackgroundColour(QColor col);
	void setGridColour(QColor col);
	void setDefaultRoomColour(QColor col);
	void setDefaultPathColour(QColor col);
	void setDefaultTextColour(QColor col);
	void setLowerRoomColour(QColor col);
	void setLowerPathColour(QColor col);
	void setHigherRoomColour(QColor col);
	void setHigherPathColour(QColor col);
	void setSelectedColour(QColor col);
	void setSpecialColour(QColor col);	
	void setLoginColour(QColor col);
	void setEditColour(QColor col);
	void setCurrentColour(QColor col);

	// Used to get the colours
	QColor getBackgroundColour(void);
	QColor getGridColour(void);
	QColor getDefaultRoomColour(void);
	QColor getDefaultPathColour(void);
	QColor getDefaultTextColour(void);	
	QColor getLowerRoomColour(void);
	QColor getLowerPathColour(void);
	QColor getHigherRoomColour(void);
	QColor getHigherPathColour(void);
	QColor getLoginColour(void);
	QColor getSelectedColour(void);
	QColor getSpecialColour(void);	
	QColor getEditColour(void);
	QColor getCurrentColour(void);

	// Misc
	bool getDoValidMoveChecking(void);
	void setDoValidMoveChecking(bool b);
	QString getFailedMoveMsg1(void);
	void setFailedMoveMsg1(QString s);
	QString getFailedMoveMsg2(void);
	void setFailedMoveMsg2(QString s);
	QString getFailedMoveMsg3(void);
	void setFailedMoveMsg3(QString s);

	void setDefaultTwoWay(bool set);
	void setDoLimitSpeedWalk(bool set);
	void setSpeedWalkLimit(int limit);
	bool getDefaultTwoWay(void);
	int getSpeedWalkLimit(void);
	bool getDoLimitSpeedWalk(void);
	int getSpeedwalkDelay(void);
	void setSpeedwalkDelay(int delay);
	
public slots:
	/**  slot called when OK button was clicked */
	void slotOKPressed();
	/**  slot called when default button was clicked */
	void slotDefaultPressed();

protected:
	DlgMapOptionsDirections* directionsTab;
	DlgMapOptionsColours* coloursTab;
	DlgMapOptionsMisc* miscTab;
	DlgMapOptionsSpeedwalk *speedwalkTab;

	QPushButton *ok_Button;
	QPushButton *cancel_Button;
};

#endif
