/***************************************************************************
                          cmapdata.cpp
                      -------------------
    description          : Used to store map data
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cmapdata.h"


CMapData::CMapData()
{
	speedwalkActive = false;
}

CMapData::~CMapData()
{
}

/** Used to read the map data */
void CMapData::readData(void)
{
	KConfig *config = kapp->getConfig();

	// Read colour data
	config->setGroup("MAPPER COLOUR");	
	backgroundColour=QColor(201,167,55);	
	backgroundColour=config->readColorEntry("Background",&backgroundColour);
	gridColour=QColor(213,178,88);	
	gridColour=config->readColorEntry("Grid", &gridColour);
	lowerRoomColour=darkGray;
	lowerRoomColour=config->readColorEntry("LowerRoom", &lowerRoomColour);
	defaultRoomColour=QColor(192,192,192);
	defaultRoomColour=config->readColorEntry("DefaultRoom", &defaultRoomColour);
	higherRoomColour=white;
	higherRoomColour=config->readColorEntry("HigherRoom", &higherRoomColour);
	lowerPathColour=darkGray;
	lowerPathColour=config->readColorEntry("LowerPath", &lowerPathColour);
	defaultPathColour=black;
	defaultPathColour=config->readColorEntry("DefaultPath", &defaultPathColour);
	higherPathColour=white;
	higherPathColour=config->readColorEntry("HigherPath", &higherPathColour);
	defaultTextColour=black;
	defaultTextColour=config->readColorEntry("DefaultText", &defaultTextColour);
	selectedColour=blue;
	selectedColour=config->readColorEntry("Selected", &selectedColour);
	specialColour = yellow;
	specialColour = config->readColorEntry("Special", &specialColour);	
	loginColour=blue;
	loginColour=config->readColorEntry("Login", &loginColour);
	editColour=red;
	editColour=config->readColorEntry("Edit",&editColour);
	currentColour=red;
	currentColour=config->readColorEntry("Current", &currentColour);

	// Read speedwalk stuff
	config->setGroup("SPEEDWALK");	
	speedwalkCatogrize = config->readNumEntry("Catogrize",0);
	speedwalkDelay = config->readNumEntry("Delay",0);
}

/** Used to write the map data */
void CMapData::writeData(void)
{
	KConfig *config = kapp->getConfig();
	
	config->setGroup("MAPPER COLOUR");	
	config->writeEntry("Background", backgroundColour);
	config->writeEntry("Grid", gridColour);
	config->writeEntry("LowerRoom", lowerRoomColour);
	config->writeEntry("DefaultRoom", defaultRoomColour);
	config->writeEntry("DefaultText", defaultTextColour);
	config->writeEntry("HigherRoom", higherRoomColour);
	config->writeEntry("LowerPath", lowerPathColour);
	config->writeEntry("DefaultPath",defaultPathColour);
	config->writeEntry("HigherPath", higherPathColour);
	config->writeEntry("Selected", selectedColour);	
	config->writeEntry("Special", specialColour);		
	config->writeEntry("Login", loginColour);	
	config->writeEntry("Edit", editColour);		
	config->writeEntry("Current", currentColour);

	config->setGroup("SPEEDWALK");	
	config->writeEntry("Catogrize",speedwalkCatogrize);
	config->writeEntry("Delay",speedwalkDelay);
}

/** Used to add a room to the speed walk list */
void CMapData::addSpeedwalkRoom(CMapRoom *room)
{
	if (speedwalkList.findRef(room)==-1)
		speedwalkList.append(room);
}

/** Used to delete a room from the speed walk list. */
bool CMapData::delSpeedwalkRoom(CMapRoom *room)
{
	return speedwalkList.remove(room);
}

