/***************************************************************************
                          kaspaurl.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          kaspaurl.h  -  description                              
                             -------------------                                         
    begin                : Wed Mar 29 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KASPAURL_H
#define KASPAURL_H
#include <qstring.h>

/**
  *@author Jan Mueller
  */

class KaspaURL {
private:
	QString _url;
public: 
	KaspaURL(const char *url);
	KaspaURL(const KaspaURL& u) {_url=qstrdup(u._url);}
	KaspaURL() { _url=""; }
	~KaspaURL();
	const QString& where();
	const QString& table();
	const QString& command();
	const bool valid();
	const bool hasCommand();
	const bool hasWhere();
	operator const char *() const { return _url; }
	operator QString () const { return QString(_url); }
	KaspaURL& operator=(const char *u) { _url=qstrdup(u); return *this; }
	KaspaURL& operator=(const KaspaURL& u) { if(!(this==&u)) _url=u._url; return *this; }
};

#endif




















