/***************************************************************************
                          journalselect.h  -  description
                             -------------------                                         
    begin                : Sat Oct 16 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef JOURNALSELECT_H
#define JOURNALSELECT_H

#include <qwidget.h>
#include <selection.h>
#include <kaspaurl.h>
/**
  *@Author Jan Mueller
  */

class JournalSelect : public Selection  {
   Q_OBJECT

private:
		JournalSelect &operator=(const JournalSelect&);
		JournalSelect(const JournalSelect&);

		KaspaBase *kaspa;
		KaspaURL _url;
public:
	JournalSelect(KaspaURL url, Sql *conn, const char *caption=0L, QWidget *parent=0, const char *name=0);
	~JournalSelect();
	bool isWorking();
	Title *getList();
	const char *url() { return _url; }
	void open(Oid o, bool w) { requestJournal(o,w); }
};

#endif