/***************************************************************************
                          htmldata.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: htmldata.h
	Last generated: Sun Sep 26 14:18:38 1999

 *********************************************************************/

#ifndef DataView_included
#define DataView_included

#include "dataviewdata.h"
#include <qfile.h>
#include "partdatabase.h"
#include <qpopupmenu.h>
#include "kaspaurl.h"
#include <kparts/mainwindow.h>

class DataView : public DataViewData
{
    Q_OBJECT
private:
		DataView(const DataView&);
		DataView& operator=(const DataView&);

protected:
    QBoxLayout *layout;
    PartDataBase *data;
		bool handling_request;
		KaspaURL _url;
	  KParts::ReadOnlyPart *part;
		QList<QFile> tmpfiles;

public:

    /** Load htmldata from WHERE clause. Must not return more than one row. Calls init().
     */
    DataView(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
	Clears any messages in the statusline.
     */
    virtual ~DataView();
    virtual const char *url() { return _url; }

    /** Creates a toolbar and alters the menu. Called by the constructors.
     */
    virtual void setWorkingGUI();
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isReadOnly() { return data->isReadOnly(); }
    virtual bool isWorking() { return data->isWorking(); }
    virtual bool closeRequest();
    virtual void setFields();

		QString oid2file();

public slots:

    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
  /**  */
    virtual void reread();

		void insLink();
		void newLink();
    void remLink();
  	void showPart();

		KToolBar *getToolBar();
};

#endif // DataView_included
