/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Don Jun 15 22:33:56 CEST 2000
                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "resource.h"
#include <iostream.h>
#include <stdlib.h>
#include "analyze.h"
#include <signal.h>
#include <unistd.h>
#include <qfile.h>


Sql svr(DB_NAME);
QList<Oid> oids;

void getOIDs(QString rel, QString field, QList<Oid>& l) {
	svr.exec("BEGIN");
	QString s("select "); s+=field+" as o from "+rel+" where "+field+" != 0";
	svr.exec(s);

	for(int i=0; i<svr.tuples(); i++) {
		Oid *o = new Oid;
		*o=QString(svr.getValue(i, "o")).toUInt();
		l.append(o);
	}
	svr.exec("END");
}


void readOIDs() {
  getOIDs("author", "memo", oids);
  getOIDs("author", "picture", oids);
  getOIDs("publication", "memo", oids);
  getOIDs("part", "memo", oids);
  getOIDs("partdata", "file", oids);
  getOIDs("note", "memo", oids);
}


int main(int argc, char** argv){
QString target;

	for(int i=0; i<argc; i++) {
		if(!strcmp(argv[i], "-o")) {
			i++;
			target=argv[i];
		}
	}
	if(target.isEmpty()) {
		cout<<"\nTool writing the large objects the kaspaliste database in a directory.\n" \
					"This program is part of the kaspaliste distribution\n (C) 2000 Jan Mueller\n" \
					"See COPYING file for the licence.\n" \
					"Syntax: unloadoids -o <directory>\n";
		exit(1);
	}


try {
	readOIDs();
	for(unsigned int i=0; i<oids.count(); i++) {
		QString s("select lo_export(");
		s+=QString().setNum(*oids.at(i));
		s+=",'"+target+"/"+QString().setNum(*oids.at(i))+"')";
		svr.exec(s);
	}
} catch (KaspaErr& err) {
	cout<<"Error: "<< err.error();
}
return EXIT_SUCCESS;
}