/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "searchdialog.moc"

SearchDialog::SearchDialog(QWidget *parent, const char *name):QDialog(parent,name,TRUE) {
this->resize(300,180);
SEARCHMODE=0; // 0=normal, 1=advanced 2=disabled
FIRST=1;
QUERY=1;
SECOND=1;


First = new QComboBox(FALSE,this,"first");
First->insertItem(klocale->translate("no Search"),0);
First->insertItem(klocale->translate("the name"),1);
First->insertItem(klocale->translate("the producer"),2);
First->insertItem(klocale->translate("the casting"),3);
First->insertItem(klocale->translate("the release-date"),4);
First->insertItem(klocale->translate("the director"),5);
Query1= new QComboBox(FALSE,this,"query1");
Query1->insertItem(klocale->translate("and"),0);
Query1->insertItem(klocale->translate("or"),1);

Second = new QComboBox(FALSE,this,"second");
Second->insertItem(klocale->translate("the name"),0);
Second->insertItem(klocale->translate("the producer"),1);
Second->insertItem(klocale->translate("the casting"),2);
Second->insertItem(klocale->translate("the release-date"),3);

Contains = new QLineEdit(this,"contains");
Contains2 = new QLineEdit(this,"contains2");

QLabel *T1 = new QLabel(this,klocale->translate("Display only those movies, where"),this);
T1->resize(400,20);
T1->move(10,10);
More = new QPushButton(klocale->translate("more ->"),this);
More->move(130,40);

First->move(30,40);

Query1->move(300-30,40);

Second->move(400-30,40);

QLabel *T2 = new QLabel(this,klocale->translate("contains"),this);
T2->move(10,70);
Contains->move(120,70);
Contains2->move(280,70);


Contains2->hide();
Query1->hide();
Second->hide();

connect(More,SIGNAL(clicked()),SLOT(slotSearchChange()));
QPushButton *OK = new QPushButton(klocale->translate("Search"),this);
QPushButton *Cancel = new QPushButton(klocale->translate("Cancel"),this);
OK->move(10,190-80);
Cancel->move(150,190-80);
connect(OK,SIGNAL(clicked()),SLOT(accept()));
connect(Cancel,SIGNAL(clicked()),SLOT(reject()));

};

void SearchDialog::slotSearchChange(){
	if (SEARCHMODE==0) {SEARCHMODE=1;} else {SEARCHMODE=0;};
        if (SEARCHMODE==1) { Query1->show(); Contains2->show(); Second->show();
	More->setText(klocale->translate("<- less"));
	this->resize(500,180);
        this->setCaption(klocale->translate("Adanced Search"));

};
	if (SEARCHMODE==0) { Query1->hide(); Contains2->hide(); Second->hide();
	More->setText(klocale->translate("more ->"));
        this->resize(300,180);
	this->setCaption(klocale->translate("Normal Search"));

};
};


	
