#include "imap.h"

ImapClient::ImapClient(const char *host, unsigned short port=143)
{
	ImapSocket = new KSocket(host, port);
	
	fd = ImapSocket->socket();

	if ( fd == -1) 
	{
	printf("Fatal: Could not create socket connection!\n");
	
	connectionState=false;
	}
	else connectionState=true;
}


ImapClient::~ImapClient()
{
	delete ImapSocket;
}

int
ImapClient::readLine(char *buffer, int bufsize)
{
  int size;
  char c;
  char* tmp;


  while ( 1 )
    {
    	while( 1 )
    	{
    	size=read(fd, (char *) &c, 1);
	if ( c == '\n') break;
	*buffer++=c;
	}
    
    *buffer=0;
    
    // Falls am zeilenende sich noch ein Return(13) befindet muss
    // auch dieses entfernt werden
   buffer--;
   if (*buffer == 13 ) *buffer=0;
   
   size=buffer-tmp;
   buffer=tmp;
   return(size);
   }
}

int
ImapClient::writeLine(char* buffer, int bufsize)
{
 return( write(fd,  buffer, bufsize) );
}

int 
ImapClient::login(const char *name, const char* password)
{
	char buffer[2048];

	sprintf((char*) &buffer, ". LOGIN %s %s\n",name, password);
	
	writeLine(buffer, strlen(buffer));

}
int 
ImapClient::logout()
{
	char *buffer=". LOGOUT\n";

	writeLine(buffer, strlen(buffer));

}

int 
ImapClient::getACL(const char *folder)
{
	char buffer[2048];

	sprintf((char*) &buffer, ". GETACL \"%s\"\n",folder);
	
	writeLine(buffer, strlen(buffer));

}

int 
ImapClient::setACL(	const char *folder, 
			const char *user, 
			const char *permissions)
{
	char buffer[2048];

	sprintf((char*)&buffer,". SETACL \"%s\" %s \"%s\"\n", folder
							    , user 
							    ,permissions);
	printf("setACL = %s", buffer);

	writeLine(buffer, strlen(buffer));

}

int
ImapClient::createFolder(const char* folderpath)
{
	char buffer[2048];

	sprintf((char*)&buffer,". CREATE \"%s\"\n", folderpath);

	printf("%s", buffer);

	writeLine(buffer, strlen(buffer));

}
int
ImapClient::deleteFolder(const char* folderpath, const char * adminusername)
{
	char buffer[2048];
	char *del_perm="lrwipcda";

	setACL(folderpath, adminusername, del_perm);
        readLine((char *) &buffer, 8192);
	printf("%s", buffer);
 	
	sprintf((char*)&buffer,". DELETE \"%s\"\n", folderpath);

	printf("%s", buffer);

	writeLine(buffer, strlen(buffer));

}
