#include "dialog.h"
#include "about.h" 				/* About dialog */
#include "addFolderDlg.h"
#include "setupDlg.h"
#include "passwordDlg.h"
#include <stdio.h>
#include <string.h>
#include <iostream.h>

#include <qaccel.h>

#include <kapp.h> 				/* klocale is defined there */
#include <kiconloader.h>
#include <ksock.h>

extern KApplication* TemplateApplication; 	/* defined in main.cpp */

#define COMBOBOX_ID 99 
#define PMBUTTON1 100
#define PMBUTTON2 101
#define PMBUTTON3 102


void 
KcyradmDlg::encodeACL(char *buffer, int bufsize)
{
  if (bufsize < 10 ) return;

  if ( l ) *buffer++='l';
  if ( r ) *buffer++='r';
  if ( s ) *buffer++='s';
  if ( w ) *buffer++='w';
  if ( i ) *buffer++='i';
  if ( p ) *buffer++='p';
  if ( c ) *buffer++='c';
  if ( d ) *buffer++='d';
  if ( a ) *buffer++='a';

  *buffer=0;
}

void 
KcyradmDlg::AddUserClicked()
{
  char buffer[8192];
  const char *username;
  const char *standard_perm="lrs";
  
  username=Username->text();

  ListBox->insertItem( username);
  xImapClient->setACL(folder.data(), username, standard_perm );
  xImapClient->readLine((char *) &buffer, 8192);

  CUserpermissions *up = new CUserpermissions;

  up->username=username;
  up->permissions=standard_perm;

  rights.append(up);
 
  printf("%s\n",buffer);
 
  // Clear 
  Username->setText("");
}

void 
KcyradmDlg::DeleteUserClicked()
{
  int item;
  const char *username;
  char buffer[8192];
   
  item     = ListBox->currentItem();
  username = ListBox->text(item);

  /* We do not need to remove it from QList because there is
     no possibility from the gui to regain access to this users */
  
  buffer[0]=0;
  xImapClient->setACL(folder.data(), username, (char *) &buffer );
  xImapClient->readLine((char *) &buffer, 8192);
  printf("%s\n",buffer);
  
  ListBox->removeItem(item);

}

void
KcyradmDlg::ButtonClicked()
{
  int item;
  const char *username;
  char buffer[8192];
  
  item = ListBox->currentItem();

  if (item == -1 ) return;  // No Item selected
  
  printf("Current Item %i\n", ListBox->currentItem());
  
  username = ListBox->text(item);
  printf("text = %s\n", username);

  /* Get Selection from Checkboxes */
  getCheckBoxes();

  encodeACL((char*)&buffer,10);

  printf("encoded ACL=%s\n", (char *)&buffer);
 
  // Store it into QList
  // Search QList for User

  findUserInQList(username, (char *) &buffer); 
  
  // Store it into Mail-Server
    xImapClient->setACL(folder, username, (char*) &buffer);
    xImapClient->readLine((char *) &buffer, 8192);
}

KcyradmDlg::KcyradmDlg(QWidget *, const char *name)
	: KTopLevelWidget( name )
{
    resize ( 600 , 480 );
    setFixedSize(size());

    SetupStatusBar();
    SetupListBox();
    SetupTreeList();

  ApplyButton = new QPushButton(i18n("Apply"), this);
  ApplyButton->setGeometry(500, 300, 94, 28);
  connect(ApplyButton, SIGNAL(clicked()), SLOT(ButtonClicked()));    
 
  DeleteUser = new QPushButton(i18n("Delete User"), this);
  DeleteUser->setGeometry(500, 340, 94, 28);
  connect(DeleteUser, SIGNAL(clicked()), SLOT(DeleteUserClicked()));    
 
  AddUser = new QPushButton(i18n("Add User"), this);
  AddUser->setGeometry(500, 420, 94, 28);
  connect(AddUser, SIGNAL(clicked()), SLOT(AddUserClicked()));    
  
  Username = new QLineEdit(this);
  Username->setGeometry(500, 380, 94, 28);
  connect(Username, SIGNAL(returnPressed()), SLOT(AddUserClicked()));    
    
	/* XXX Delete fr die QCheckBoxen muss noch gemacht werden */

  lookup	= new QCheckBox(i18n("Lookup"),this);
  CHECK_PTR(lookup);
  lookup->adjustSize();
  lookup->setGeometry(404,280, lookup->width(), lookup->height());
  lookup->setChecked(false);
 // lookup->setChecked(acc->execScripts);
  //connect(lookup, SIGNAL(clicked()), SLOT(slotEnableExecution()));

   read  	= new QCheckBox(i18n("Read"),this);
  CHECK_PTR(read);
  read->adjustSize();
  read->setGeometry(404, 300, read->width(), read->height());
  read->setChecked(false);
 // read->setChecked(acc->execScripts);
  //connect(read, SIGNAL(clicked()), SLOT(slotEnableExecution()));
  
   store_seen	= new QCheckBox(i18n("Store"),this);
  CHECK_PTR(store_seen);
  store_seen->adjustSize();
  store_seen->setGeometry(404, 320, store_seen->width(), store_seen->height());
  store_seen->setChecked(false);
 // store_seen->setChecked(acc->execScripts);
  //connect(store_seen, SIGNAL(clicked()), SLOT(slotEnableExecution()));
   
  write	= new QCheckBox(i18n("Write"),this);
  CHECK_PTR(write);
  write->adjustSize();
  write->setGeometry(404, 340, write->width(), write->height());
  write->setChecked(false);
  //write->setChecked(acc->execScripts);
  //connect(write, SIGNAL(clicked()), SLOT(slotEnableExecution()));
  
  
  insert = new QCheckBox(i18n("Insert"),this);
  CHECK_PTR(insert);
  insert->adjustSize();
  insert->setGeometry(404, 360, insert->width(), insert->height());
  insert->setChecked(false);
 // insert->setChecked(acc->execScripts);
  //connect(insert, SIGNAL(clicked()), SLOT(slotEnableExecution()));
  
  post	= new QCheckBox(i18n("Post"),this);
  CHECK_PTR(post);
  post->adjustSize();
  post->setGeometry(404, 380, post->width(), post->height());
  post->setChecked(false);
  //post->setChecked(acc->execScripts);
  //connect(post, SIGNAL(clicked()), SLOT(slotEnableExecution()));
 
  create	= new QCheckBox(i18n("Create"),this);
  CHECK_PTR(create);
  create->adjustSize();
  create->setGeometry(404, 400, create->width(), create->height());
  create->setChecked(false);
 // create->setChecked(acc->execScripts);
  //connect(create, SIGNAL(clicked()), SLOT(slotEnableExecution()));
 
   store_delete	= new QCheckBox(i18n("Delete"),this);
  CHECK_PTR(store_delete);
  store_delete->adjustSize();
  store_delete->setGeometry(404, 420, store_delete->width(), store_delete->height());
  store_delete->setChecked(false);
 // store_delete->setChecked(acc->execScripts);
  //connect(store_delete, SIGNAL(clicked()), SLOT(slotEnableExecution()));
 
   administer	= new QCheckBox(i18n("Administer"),this);
  CHECK_PTR(administer);
  administer->adjustSize();
  administer->setGeometry(404, 440, administer->width(), administer->height());
  administer->setChecked(false);
 // administer->setChecked(acc->execScripts);
  //connect(administer, SIGNAL(clicked()), SLOT(slotEnableExecution()));

	
/*
	Das muss noch als Button realisiert werden!!!


           none      ""
           read      lrs
           post      lrsp
           append    lrsip
           write     lrswipcd
           all       lrswipcda
                        
*/
    KConfig *kc = TemplateApplication->getConfig();
    kc->setGroup("Configuration");
    
    /* Look if started the first time */
    if (  kc->readEntry("Host") == NULL )
    {
    kc->writeEntry("Host", "127.0.0.1");			
    kc->writeEntry("Port", "143");
    kc->writeEntry("Username", "YourAminUserName");
    kc->writeEntry("Password", "XXX");
    kc->sync();
    }
    
    QString mailserver = "Mail on ";
    mailserver.append(  kc->readEntry("Host"));

    TreeList->insertItem(mailserver.data(),NULL);
   
    int size;
    char buffer[8192];
    char *listmailboxes = ". LIST . *\n";

	// XXX Hier fehlt noch ein delete irgendwo 
    xImapClient = new ImapClient(kc->readEntry("Host"));

    if (xImapClient->connectionState == false)
    {
      printf("Please specify IP-Address\n");
      SetupCyradm();
      xImapClient = new ImapClient(kc->readEntry("Host"));
    }
    

    xImapClient->readLine((char *)&buffer, 8192);
    printf("%s\n", buffer);
 
 	/* XXX Username und pass sollten im ImapClient abgespeichert werden! */
   
    xImapClient->login(kc->readEntry("Username"),kc->readEntry("Password"));
    xImapClient->readLine((char *)&buffer, 8192);
    printf("%s\n", buffer);
  
    if (strcmp(". NO Login incorrect", (char *)&buffer)==0)
    {
 	printf("Please specify correct Username and Password\n");
    	SetupCyradm();
	xImapClient->login(kc->readEntry("Username"),kc->readEntry("Password"));
        xImapClient->readLine((char *)&buffer, 8192);
        printf("%s\n", buffer);
    }
 
    AdminUser=kc->readEntry("Username");
 
    xImapClient->writeLine(listmailboxes, strlen(listmailboxes));
    printf("%s", listmailboxes);
  
    while( 1 )
    {
    
      xImapClient->readLine((char *)&buffer, 8192);
      if ( strcmp(buffer, ". OK Completed") == 0 ) break;
     	char *strptr = (char *) &buffer;
	 
	//* LIST () "." INBOX.Privat
	//* LIST (\Noinferiors) "." Faxe
	//* LIST (\Noinferiors) "." Global  

	/* to the first " */
	while (*strptr != '"') strptr++;
     	
	strptr++;
	/* To the second " */
	while (*strptr != '"') strptr++;

	strptr++;
	strptr++;
 
      // Entfernen von Hochkommas um die Strings
      if (*strptr == '"' ) 
      {
        strptr++; 
        char *test=strptr;
        while( *test!=0) test++;
        test--;
        *test=0;
      }

      char* tmp;
      int iterations=0;

      tmp=strtok(strptr, ".");
      CreatePathRecursive(tmp, TreeList->itemAt(0));

    }
    
    connect( TreeList, SIGNAL(highlighted(int)), 
   	     this,     SLOT(TreeListhighlighted(int))
	   );
    
    SetupMainMenuBar();
    SetupToolBar();
    
    /*
     * Keyboard functions
     */

    accel = new QAccel (this);
 //   accel->connectItem( accel->insertItem( Key_Delete ), this, SLOT(RemoveJob()) );
   // accel->connectItem( accel->insertItem( Key_Backspace ), this, SLOT(RemoveJob()) );
	
}
void 
KcyradmDlg::RemoveFolder()
{
   int item;
   char buffer[81292];

   item = TreeList->currentItem();

   if (item == -1 ) return; // No Item selected
   
   KTreeListItem * test = TreeList->itemAt(item);

   if (test->hasChild()) return;  // No Deletion of Items with childs
  

   xImapClient->deleteFolder(folder.data(), AdminUser.data());
   xImapClient->readLine((char *) &buffer, 8192);
   printf("%s",buffer);

   TreeList->removeItem(item);
   TreeList->repaint(true);
}

void 
KcyradmDlg::AddFolder()
{
   addFolderDlg *dlg = new addFolderDlg(0);
   QPoint point = this->mapToGlobal (QPoint (0,0));
   QRect pos    = this->geometry();
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
		     point.y() + pos.height()/2 - dlg->height()/2, 
		     dlg->width(),dlg->height());

   dlg->exec();
   
   printf("%s\n",dlg->folder.data());
   addFolder(dlg->folder.data());
   delete dlg;
   
   TreeList->repaint(true);
}

void
KcyradmDlg::addFolder(const char* foldername)
{
   int item;
   char buffer[81292];

   item = TreeList->currentItem();

   if (item == -1 ) return; // No Item selected

  // Get folderpath
  // folderpath+ foldername = new folderpath
  // createFolder(newfolderpath)
  
  QString Path="";
  
  if (folder.data() != 0)
  {
  Path=folder.data();
  Path.append(".");
  }
  Path.append(foldername);


  xImapClient->createFolder(Path.data());
  xImapClient->readLine((char *) &buffer, 8192);
	 
  KTreeListItem *test = new KTreeListItem(foldername,NULL);
  KTreeListItem *parent = TreeList->itemAt(item);
  parent->appendChild(test);
 

}


void 
KcyradmDlg::CreatePathRecursive(char* path, KTreeListItem* item)
{
 KTreeListItem *firstchilditem;
 
 if (path == NULL) return;
 //printf(">>%s<<", path);

 firstchilditem = item->getChild();
 KTreeListItem *found = findByName(firstchilditem, QString(path));
 
 if (found == NULL) 
   {
   KTreeListItem *test = new KTreeListItem(path,NULL);
   item->appendChild(test);
   }

 found = findByName(item->getChild(), QString(path));

 //if (found == NULL)  printf("Found == NULL\n");

 CreatePathRecursive(strtok(NULL, "."),  found );

}

KTreeListItem *
KcyradmDlg::findByName(KTreeListItem *start, QString name)
{
  // printf("findByName->");
  
  if (start == NULL) return NULL;

  KTreeListItem *item = start;
  while(item) {
    // cout << "getText =" << item->getText() << "\n" ;
    if(item->getText() == name)
      return item;
    item = item->getSibling();
  }
  return NULL;
}

void
KcyradmDlg::decodeACL(const char *acl)
{
  l=r=s=w=i=p=c=d=a=0;

while (*acl!=0) {
  
  switch(*acl) {
    case 'l': {l=1; break;}
    case 'r': {r=1; break;}
    case 's': {s=1; break;}
    case 'w': {w=1; break;}
    case 'i': {i=1; break;}
    case 'p': {p=1; break;}
    case 'c': {c=1; break;}
    case 'd': {d=1; break;}
    case 'a': {a=1; break;}
		    
    default:  break;
    }

  acl++;
  }
}

void
KcyradmDlg::TreeListhighlighted(int index)
{
 
 	KPath *test=TreeList->itemPath(index);
	
	if ( test==NULL) return;

	/* Reconstruct FolderPath from KPath */

	QString *x;
	QString path,xpath;
	
	while(1){
	  x = test->pop();
	  if ( test->isEmpty() ) break;
	
	  //printf("%s", x->data());
	  xpath = QString(x->data());
	  xpath.append(".");
	  xpath.append(path.data());
	
	  path = xpath;

	}
	
	// Denn letzten Punkt am String ende wieder lschen

	if (!path.isNull() ) {
	path=path.left(path.length()-1);
	}
	
	// Den Pfad global speichern

	folder=path;
	
	//cout << path << "\n" ;


	// . GETACL ordnername
	// Bsp. 
	// . GETACL global
	// * ACL global anyone lrs s_dkling lrswipcda armin lrs
	// . OK Completed  
	
	char buffer[8192];
	xImapClient->getACL(path.data());
	xImapClient->readLine((char *) &buffer, 8192);
	printf("ACL%s\n",(char *) &buffer);
	
	if (! strcmp(". NO Mailbox does not exist", (char *) &buffer) ==0)
	{
	// Decode 

	// * ACL user.s_dkling s_dkling lrswipcda 
	// 1 2   3
	// a) Jump to String 3
	// b) Look if it is set in ""
	// c) Jump to the end of String 3


	char* tmp;
	char* strptr = (char *) &buffer;
	
	// a) Jump to String 3
	int ii=0;
	while (ii!=2) 
	{
	if (*strptr++==' ') ii++;
	}

	// b+c) Look if it set in ""

	if (*strptr=='"') 
	{ // Jump behind "
	   strptr++;
	   printf("set into braces!\n");
	  while (*strptr++!='"');
	  strptr++;  // Jump over space
	}
	else 
	{ strptr++;
	while (*strptr++!= ' ');}
	
	ListBox->clear();
	rights.clear();
	
	CUserpermissions *Userpermissions= new CUserpermissions;
	
	/* Get Username */
      	tmp=strtok(strptr, " ");
	printf("%s\n", tmp);
	Userpermissions->username=tmp;
	ListBox->insertItem(tmp);
      
	/* Get Rights */
	tmp=strtok(NULL, " ");
	printf("Get Rights:%s\n", tmp);
	Userpermissions->permissions=tmp;
	
	rights.append(Userpermissions);


	decodeACL(tmp);

	SetCheckBoxes();

	while (1)
	{
	/* Get Username */
	tmp = strtok(NULL, " \"");
	if (tmp == NULL ) break;
	Userpermissions= new CUserpermissions;	
	Userpermissions->username=QString(tmp);
	cout << " >> " << Userpermissions->username.data() << "\n";
	ListBox->insertItem(tmp);
      
	/* Get Rights */
	tmp = strtok(NULL, " \"");
	Userpermissions->permissions=QString(tmp);
	printf("%s\n",tmp);

	rights.append(Userpermissions);
	}
	// Read Ok Line
	xImapClient->readLine((char *) &buffer, 8192);
	printf("%s\n",(char *) &buffer);
	}	
	statusbar->changeItem(path.data(), ID_GENERAL);
	//getACL("anyone", (char *)&buffer);
	
	delete test;
}

void
KcyradmDlg::getCheckBoxes()
{
   l=lookup->isChecked();
   r=read->isChecked();
   s=store_seen->isChecked();
   w=write->isChecked();
   i=insert->isChecked();
   p=post->isChecked();
   c=create->isChecked();
   d=store_delete->isChecked();
   a=administer->isChecked();
}

void
KcyradmDlg::SetCheckBoxes()
{
	lookup->setChecked(l);
	read->setChecked(r);
	store_seen->setChecked(s);
	write->setChecked(w);
	insert->setChecked(i);
	post->setChecked(p);
	create->setChecked(c);
	store_delete->setChecked(d);
	administer->setChecked(a);

}
void
KcyradmDlg::findUserInQList(const char *username, const char* permissions )
{
  CUserpermissions *up;
  up = rights.at(0);
 printf("usrname.data()=%s\n",up->username.data());
  
  while( strcmp(up->username.data(), username) !=0 )
  {
  up = rights.next();
  if (up == NULL) break;
  }
  if ( up != NULL) 
  { printf("findUser:perms now = %s\n", up->permissions.data());
    up->permissions=permissions;
  }
  
  printf("ENDE\n");
}

void
KcyradmDlg::getACL(const char* username)
{
  if ( rights.isEmpty() ) return;
 
  CUserpermissions *up;

  up = rights.at(0);

  printf("getACL(%i) \n",rights.count());
  printf("usrname.data()=%s\n",up->username.data());
  
  while( strcmp(up->username.data(), username) !=0 )
  {
  printf("before next\n");
  up = rights.next();
  printf("after next\n");
  printf("%i\n", up);
  if (up == NULL) break;
  printf("2usrname.data()=%s\n",up->username.data());
  }
 
  if (up != NULL ) {
    
    printf("ACL=%s\n", up->permissions.data());
    decodeACL(up->permissions.data());
    SetCheckBoxes();
  }

}


void
KcyradmDlg::SetupListBox()
{
	ListBox	=	new QListBox(this, "test");
	ListBox->setGeometry( 402, 54, 597, 224 );
	connect(ListBox, 
		SIGNAL(highlighted(const char*)), 
		this, 
		SLOT(getACL(const char*)));
   
}



void
KcyradmDlg::DestroyListBox()
{
	delete ListBox;
}

void 
KcyradmDlg::SetupToolBar()
{
	/*
	 * Setup Toolbar 
	 */
	
	toolbar 	    = new KToolBar( this );
	KIconLoader *loader = TemplateApplication->getIconLoader();
	
	toolbar->setBarPos( KToolBar::Top );

	toolbar1 = addToolBar(toolbar);
	/*
	toolbar->insertCombo(	"all", COMBOBOX_ID , 0, 
				SIGNAL(activated(const char*)), this,
				SLOT(ListPrintQueue())
			     );
	*/
	//QString pixdir = TemplateApplication->kdedir() +
	QString pixdir = QString("/usr/local/kde/share/apps/klpc/toolbar/");  
  	
	loader = TemplateApplication->getIconLoader();
	
	QPixmap pixmap= loader->loadIcon("make.xpm");
	
  	toolbar->insertButton(	pixmap, PMBUTTON1,
		      		SIGNAL(clicked()), this,
		      		SLOT(AddFolder()), TRUE, klocale->translate("Add Folder "));
 
  	QPixmap pixmap2= loader->loadIcon("exit.xpm");
	
  	toolbar->insertButton(	pixmap2, PMBUTTON2,
		      		SIGNAL(clicked()), this,
		      		SLOT(RemoveFolder()), TRUE, klocale->translate("Remove Folder"));
	/*
	QPixmap pixmap3((pixdir + "pause.xpm").data());
	
  	toolbar->insertButton(	pixmap3, PMBUTTON3,
		      		SIGNAL(clicked()), this,
		      		SLOT(HoldAll()), TRUE, klocale->translate("Drucken anhalten"));
 */
	enableToolBar( KToolBar::Show, toolbar1 );
}


KcyradmDlg::SetupMainMenuBar()
{
	menubar	=	new KMenuBar (this, "menubar");
	file 	=	new QPopupMenu ();
	edit 	=       new QPopupMenu ();
	options =	new QPopupMenu ();
  	help 	=	new QPopupMenu ();
	
	/* 
	 * Insert Items for File menu 
	 */
	file->insertItem (	klocale->translate("&Add Folder"),
		    		this, SLOT(AddFolder()));
	file->insertItem (	klocale->translate("&Delete Folder"),
		    		this, 	SLOT(RemoveFolder()));
	file->insertSeparator (-1);		

	file->insertItem (	klocale->translate("&Setup"),
		    		this, SLOT(SetupCyradm()));
	file->insertSeparator (-1);		
	/*
	file->insertItem (	klocale->translate("Einstellung fr Dokumente..."),
		    		this, 	SLOT(PrinterMenuSave()));
	file->insertItem (	klocale->translate("F&reigabe..."),
		    		this, SLOT(PrinterMenuSaveAs()));
	file->insertSeparator(-1);
	file->insertItem (	klocale->translate("Druckauftrge &lschen"),
		    		this, 	SLOT(PrinterMenuExit()));
	file->insertSeparator(-1);
	file->insertItem (	klocale->translate("&Eigenschaften"),
		    		this, 	SLOT(PrinterMenuExit()));
	file->insertSeparator(-1);
	*/
	file->insertItem (	klocale->translate("&Exit"),
		    		this, 	SLOT(PrinterMenuExit()));
			
	/* 
	 * Insert Items for Edit Menu 
	 */

  	edit->insertItem(	klocale->translate("An&halten"),
			   	this, 	SLOT(EditMenuUndo()));
  	edit->insertItem(	klocale->translate("&Fortsetzen"),
			   	this, 	SLOT(EditMenuUndo()));
  	edit->insertItem(	klocale->translate("&Neu starten"),
			   	this, 	SLOT(EditMenuUndo()));
	edit->insertSeparator(-1);	
  	
	edit->insertItem(	klocale->translate("&Abbrechen"),
			   	this, 	SLOT(EditMenuCut()));
	edit->insertSeparator(-1);		
  	edit->insertItem(	klocale->translate("&Eigenschaften"),
			   	this, 	SLOT(EditMenuCopy()));
	
	
	
	options->insertItem(	klocale->translate("&Statusleiste"),
				this, 	SLOT(AddFolder()));
//	options->insertItem(	klocale->translate("A&ktualisieren"),
//				this, 	SLOT(ListPrintQueue())
//			  );
	
	/*
	 * Insert Items for Help menu 
	 */
	
	help->insertItem (	klocale->translate("&Hilfethemen"),
		    		this, SLOT(HelpMenuHelp()));
	help->insertItem (	klocale->translate("Inf&o..."),
		    		this, 	SLOT(HelpMenuAbout()));
  	
	/* 
	 * Equip menubar
	 */
	
	menubar->setGeometry( 0, 0, 400, 30 );

	menubar->insertItem (klocale->translate("&File"), 	file);
//	menubar->insertItem (klocale->translate(""), 	edit);
//	menubar->insertItem (klocale->translate("&Options"), 	options);

	menubar->insertSeparator(-1); 
	
	menubar->insertItem (klocale->translate("&Help"),	help);

	setMenu(menubar);
	menubar->show();
}
void
KcyradmDlg::HelpMenuAbout()
{
	/* Tell us something about you */
    QDialog *dlg = new About(0);
    QPoint point = this->mapToGlobal (QPoint (0,0));
    QRect pos 	 = this->geometry();
    dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
		     point.y() + pos.height()/2 - dlg->height()/2, 
		     dlg->width(),dlg->height());

    dlg->exec();
    delete dlg;
}

void
KcyradmDlg::HelpMenuHelp()
{
	/* 
	 * Tell us something about you 
	 */
	 
	printf("HelpMenuHelp()\n");
}

void
KcyradmDlg::SetupCyradm()
{
	/* 
	 * Tell us something about you
	 */
	printf("SetupCyradm()\n");
    setupDlg *dlg = new setupDlg(0);
    QPoint point = this->mapToGlobal (QPoint (0,0));
    QRect pos 	 = this->geometry();
    /*
    dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
		     point.y() + pos.height()/2 - dlg->height()/2, 
		     dlg->width(),dlg->height());
*/
    dlg->exec();
    delete dlg;
}

void
KcyradmDlg::PrinterMenuExit()
{
	char buffer[81292];
	/* Tell us something about you */
	printf("PrinterMenuExit()\n");
  
       xImapClient->logout();
       xImapClient->readLine((char *)&buffer, 8192);
       printf("%s\n", buffer);
 	
	TemplateApplication->quit();
}

void 
KcyradmDlg::EditMenuUndo()
{
	printf("EditMenuUndo()\n");
}
void 
KcyradmDlg::EditMenuCut()
{
	printf("EditMenuCut()\n");
}
void 
KcyradmDlg::EditMenuCopy()
{
	printf("EditMenuCopy\n");
}
void 
KcyradmDlg::EditMenuPaste()
{
  printf("EditMenuPaste()\n");

}

void 
KcyradmDlg::OptionsMenuConfigure()
{
	printf("OptionsMenuConfigure()\n");
}
void
KcyradmDlg::SetupTreeList()
{
	TreeList	=	new KTreeList(this, "test");
	TreeList->setGeometry( 0, 54, 400, 400 );
}


void
KcyradmDlg::SetupStatusBar()
{
    statusbar = new KStatusBar( this );
  //  statusbar->insertItem("Druckerstatus: angehalten", ID_LINE_COLUMN);
  //  statusbar->insertItem("   ", ID_INS_OVR);
    statusbar->insertItem("Welcome to the wonderful world of kcyradm :)", ID_GENERAL);

    statusbar->setInsertOrder(KStatusBar::RightToLeft);
    //statusbar->setAlignment(ID_INS_OVR,AlignCenter);
    
    setStatusBar( statusbar );

}
KcyradmDlg::~KcyradmDlg()
{
 
    delete accel;
    
    delete lprm;
    delete lpq;
    delete lpc;
    
    delete ListBox;
    delete statusbar;
    delete toolbar;
    delete menubar;
    
    delete file;
    delete edit;
    delete options;
    delete help;
}
