/***************************************************************************
                          cajoutfichiers.cpp  -  description
                             -------------------
    begin                : Thu Jun 3 1999
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "cajoutfichiers.h"

#define Inherited QDialog


/***************************************************************************
 *  Methods of liste class
 *
 *
 ***************************************************************************/

liste::liste (QWidget* parent, const char* name):QListView( parent, name )
{
}

/*Send a message each time a file is selected
	files are items that do not have a pixmap*/
void liste::mouseReleaseEvent(QMouseEvent* e)
{
	QListViewItem* l;
	
	l=itemAt(e->pos());
	if((l!=NULL)&&(l->pixmap(0)==NULL))
		emit selectionChangee(l);
}



/***************************************************************************
 *  Methods of CAjoutFichiers class
 *
 *
 ***************************************************************************/
	
CAjoutFichiers::CAjoutFichiers
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, TRUE, 0 )
{
	listView = new liste( this, "ListView_1" );
	listView->setGeometry( 0, 0, 170, 300 );
	listView->setFixedSize( 170, 300 );
	listView->setFocusPolicy( QWidget::TabFocus );
	listView->setBackgroundMode( QWidget::PaletteBackground );
	listView->setFontPropagation( QWidget::NoChildren );
	listView->setPalettePropagation( QWidget::NoChildren );
	listView->setFrameStyle( 0 );
	listView->setLineWidth( 1 );
	listView->setMidLineWidth( 0 );
	listView->QFrame::setMargin( 0 );
	listView->setResizePolicy( QScrollView::Manual );
	listView->setVScrollBarMode( QScrollView::Auto );
	listView->setHScrollBarMode( QScrollView::Auto );
	listView->setTreeStepSize( 20 );
	listView->setMultiSelection( FALSE );
	listView->setAllColumnsShowFocus( FALSE );
	listView->setItemMargin( 1 );
	listView->setRootIsDecorated( FALSE );
	listView->addColumn( i18n("Choose files:"), -1 );
	listView->setColumnWidthMode( 0, QListView::Maximum );
	listView->setColumnAlignment( 0, 1 );

	repertoire=new Directory(listView);
	repertoire->setAfficheFichiers(TRUE);
	listView->setMultiSelection(TRUE);
	repertoire->setOpen(TRUE);
  connect(listView, SIGNAL(selectionChangee(QListViewItem*)), this, SLOT(slotSelectionModifiee(QListViewItem*)));

	QButtonGroup* qtarch_ButtonGroup;
	qtarch_ButtonGroup = new QButtonGroup( this, "ButtonGroup" );
	qtarch_ButtonGroup->setGeometry( 230, 10, 160, 180 );
	qtarch_ButtonGroup->setMinimumSize( 0, 0 );
	qtarch_ButtonGroup->setMaximumSize( 32767, 32767 );
	qtarch_ButtonGroup->setFocusPolicy( QWidget::NoFocus );
	qtarch_ButtonGroup->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_ButtonGroup->setFontPropagation( QWidget::NoChildren );
	qtarch_ButtonGroup->setPalettePropagation( QWidget::NoChildren );
	qtarch_ButtonGroup->setFrameStyle( 49 );
	qtarch_ButtonGroup->setLineWidth( 1 );
	qtarch_ButtonGroup->setMidLineWidth( 0 );
	qtarch_ButtonGroup->QFrame::setMargin( 0 );
	qtarch_ButtonGroup->setTitle( i18n("Kind of operation:") );
	qtarch_ButtonGroup->setAlignment( 1 );
	qtarch_ButtonGroup->setExclusive( FALSE );

	connect(qtarch_ButtonGroup,SIGNAL(clicked(int)), this, SLOT(selectionneMotif(int)));


	qtarch_RadioAjoute = new QRadioButton( this, "RadioAjoute" );
	qtarch_RadioAjoute->setGeometry( 250, 30, 120, 30 );
	qtarch_RadioAjoute->setMinimumSize( 0, 0 );
	qtarch_RadioAjoute->setMaximumSize( 32767, 32767 );
	qtarch_RadioAjoute->setFocusPolicy( QWidget::TabFocus );
	qtarch_RadioAjoute->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_RadioAjoute->setFontPropagation( QWidget::NoChildren );
	qtarch_RadioAjoute->setPalettePropagation( QWidget::NoChildren );
	qtarch_RadioAjoute->setText( i18n("Add files") );
	qtarch_RadioAjoute->setAutoRepeat( FALSE );
	qtarch_RadioAjoute->setAutoResize( FALSE );
	qtarch_RadioAjoute->setChecked( TRUE );


	qtarch_RadioUpdate = new QRadioButton( this, "RadioUpdate" );
	qtarch_RadioUpdate->setGeometry( 250, 90, 120, 30 );
	qtarch_RadioUpdate->setMinimumSize( 0, 0 );
	qtarch_RadioUpdate->setMaximumSize( 32767, 32767 );
	qtarch_RadioUpdate->setFocusPolicy( QWidget::TabFocus );
	qtarch_RadioUpdate->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_RadioUpdate->setFontPropagation( QWidget::NoChildren );
	qtarch_RadioUpdate->setPalettePropagation( QWidget::NoChildren );
	qtarch_RadioUpdate->setText( i18n("Update files") );
	qtarch_RadioUpdate->setAutoRepeat( FALSE );
	qtarch_RadioUpdate->setAutoResize( FALSE );
	qtarch_RadioUpdate->setChecked( FALSE );

	qtarch_RadioMotif = new QRadioButton( this, "RadioMotif" );
	qtarch_RadioMotif->setGeometry( 250, 150, 120, 30 );
	qtarch_RadioMotif->setText( i18n("Use wilcards") );
	qtarch_RadioMotif->setChecked( FALSE );

	qtarch_CheckBox = new QCheckBox( this, "CheckBox" );
	qtarch_CheckBox->setGeometry( 230, 200, 160, 30 );
	qtarch_CheckBox->setMinimumSize( 0, 0 );
	qtarch_CheckBox->setMaximumSize( 32767, 32767 );
	qtarch_CheckBox->setFocusPolicy( QWidget::TabFocus );
	qtarch_CheckBox->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_CheckBox->setFontPropagation( QWidget::NoChildren );
	qtarch_CheckBox->setPalettePropagation( QWidget::NoChildren );
	qtarch_CheckBox->setText( i18n("Delete source files") );
	qtarch_CheckBox->setAutoRepeat( FALSE );
	qtarch_CheckBox->setAutoResize( FALSE );
	qtarch_CheckBox->setChecked( FALSE );

	QPushButton* qtarch_PushOK;
	qtarch_PushOK = new QPushButton( this, "PushOK" );
	qtarch_PushOK->setGeometry( 350, 250, 50, 25 );
	qtarch_PushOK->setMinimumSize( 0, 0 );
	qtarch_PushOK->setMaximumSize( 32767, 32767 );
	qtarch_PushOK->setFocusPolicy( QWidget::TabFocus );
	qtarch_PushOK->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_PushOK->setFontPropagation( QWidget::NoChildren );
	qtarch_PushOK->setPalettePropagation( QWidget::NoChildren );
	qtarch_PushOK->setText( i18n("OK") );
	qtarch_PushOK->setAutoRepeat( FALSE );
	qtarch_PushOK->setAutoResize( FALSE );
	qtarch_PushOK->setToggleButton( FALSE );
	qtarch_PushOK->setDefault( FALSE );
	qtarch_PushOK->setAutoDefault( FALSE );
	qtarch_PushOK->setIsMenuButton( FALSE );
	connect(qtarch_PushOK,SIGNAL(clicked()),SLOT(OK()));

	QPushButton* qtarch_PushCancel;
	qtarch_PushCancel = new QPushButton( this, "PushCancel" );
	qtarch_PushCancel->setGeometry( 350, 280, 50, 25 );
	qtarch_PushCancel->setText( i18n("Cancel") );
	connect(qtarch_PushCancel,SIGNAL(clicked()),SLOT(Cancel()));

	qtarch_LineFichiers = new QMultiLineEdit( this, "LineFichiers" );
	qtarch_LineFichiers->setGeometry( 180, 235/*265*/, 160, 60/*20*/ );

	qtarch_ButtonGroup->insert( qtarch_RadioAjoute );
	qtarch_ButtonGroup->insert( qtarch_RadioUpdate );
	qtarch_ButtonGroup->insert( qtarch_RadioMotif );

	resize( 400,305 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );
	chemin="";
}


CAjoutFichiers::~CAjoutFichiers()
{
}

void CAjoutFichiers::choisirFichiers()
{
	QFileDialog selectionFichiers(QDir::currentDirPath());
	//selectionFichiers.setMultiSelection(TRUE);
	//QStrList receptionfichiers=selectionFichiers.selectedFileURLList();

	if(selectionFichiers.exec())
	{
		//receptionfichiers=selectionFichiers.selectedFileURLList();
		//for(int i=0;i<receptionfichiers.selectedFileURLList().count();i++)
		//	printf("\n*%s*\n",receptionfichiers.take(i));
  }
}

void CAjoutFichiers::reconstruitChemin(QListViewItem *l)
{
	if(l->depth()!=0)
	{
		chemin="/"+chemin;
		chemin=l->text(0)+chemin;
		reconstruitChemin(l->parent());
	}
	else
	{
		chemin="/"+chemin;
		QString str;
		int i;
		
		i=0;
	  for (const char* f = listeFichiers.first(); f; f = listeFichiers.next())
    {
    	str=f;
    	if(strcmp((const char*)str,chemin)==0)
			{
				listeFichiers.remove(str);
				qtarch_LineFichiers->removeLine(i);
				chemin="";
				return;
			}
			i++;
    }
			listeFichiers.append(chemin);
			qtarch_LineFichiers->insertLine(chemin);
		chemin="";
	}
}

QStrList CAjoutFichiers::getFichiers()
{
	return listeFichiers;
}

void CAjoutFichiers::OK()
{
	done(0);
}

void CAjoutFichiers::Cancel()
{
	done(1);
}

int CAjoutFichiers::getAction()
{
	if(qtarch_RadioAjoute->isChecked())
		return 0;
	else	if(qtarch_RadioUpdate->isChecked())
		return 1;
	return -1;
}

bool CAjoutFichiers::getEnleveFichiers()
{
	return qtarch_CheckBox->isChecked();
}

void CAjoutFichiers::selectionneMotif(int i)
{
	if(i==2)
	{
		QStrList listeFichiers2;
		
		listeFichiers=QFileDialog::getOpenFileNames("",QDir::homeDirPath());

		listeFichiers2=listeFichiers;
		qtarch_LineFichiers->clear();

	  for (const char* f = listeFichiers.first(); f; f = listeFichiers.next())
   		qtarch_LineFichiers->insertLine(f);
   		
		listeFichiers=listeFichiers2;
	}
}

void CAjoutFichiers::MAJMotif(/*const char* texte*/)
{
	if(qtarch_RadioMotif->isChecked())
	{
		QString txt;
//		txt=texte;
		txt+="/";
		listeFichiers.clear();
		listeFichiers.append(txt);
//printf("\n*%s*\n",texte);
	}
}

void CAjoutFichiers::slotSelectionModifiee(QListViewItem* l)
{
		reconstruitChemin(l);
}
