#include <kapp.h>
#include "myfft.moc"
#include "oss.h"

#define   FAST  10
#define   FALLING  11
#define   SMOOTH  12
#define   STICKY  13

MYFFT::MYFFT(QWidget *parent) : QWidget(parent)
{
  int i;
  setFixedSize(420,160);
  for(i=0;i<20;i++)
    {
      vue[i] = new Qvumeter(
			   33,			// number of steps (leds)
			   0, 99,		// range min, range max
			   // "lin",		// scale
			   15,			// damping (between 0 and 100)
			   23-i/2,28-i/3,31,		// led color changes
		           'V',			// orientation, LED set
			   this );
      vue[i]->move(10+20*i,5);
    }
  QFont f("Helvetica", 8, QFont::Bold);

  freqStr = new QLabel("100Hz\t\t 325Hz\t\t 1khz\t\t 5khz\t 10khz\t20khz",this);
  freqStr->setAutoResize(TRUE);
  freqStr->setFont( f );
  freqStr->move(5,140);
}


FFT::FFT()
{
  muted = 0;
  int blks = 8192;

  card = new Soundcard("/dev/audio");
  SOUNDPARAMS cardset;
  cardset.format = FMT_16BIT;
  cardset.channels = 1;
  cardset.rate = 44100;
  cardset.blocksize = blks;
  cardset.latency = blks*1024/1/44100;

  card->setparams(&cardset);

  makeMenu();

  fftwin    = new FFTWindow(0,"fft");
  fftwin->hide();
  fftDisp = new MYFFT(this);

  connect(card,SIGNAL(senddata(void*)), fftwin, SLOT(new_data(void*)));
  connect(card,SIGNAL(newparams(struct SOUNDPARAMS*)), fftwin,
    SLOT(new_params(struct SOUNDPARAMS*)));    
  connect(fftwin,SIGNAL(sendData(freqdata*)), fftDisp,
    SLOT(getData(freqdata*)));

  setView(fftDisp);
  setCaption("freq spectrum");

  card->start_record();
//  setFixedSize(420,200);
}

FFT::~FFT()
{
}

void FFT::makeMenu()
{
  mainMenu = new KMenuBar(this,"main_menu");
  mainMenu->insertItem("Quit", qApp, SLOT(quit()));
  mainMenu->insertItem("Pause", this, SLOT(pause()));

  QPopupMenu *Modes = new QPopupMenu;
  Modes->insertItem("Fast", FAST);
  Modes->insertItem("Falling", FALLING);
  Modes->insertItem("Smooth", SMOOTH);
  Modes->insertItem("Sticky",STICKY);

  QPopupMenu *help = kapp->getHelpMenu(true, QString("Specturm Analyser")
    +"\n\n" + "Copywrite" + "1998 Carl van Schaik (carl@leg.uct.ac.za)");

  mainMenu->insertItem("Mode", Modes);
  mainMenu->insertItem("Help", help);
  setMenu(mainMenu);
  connect( mainMenu, SIGNAL(activated(int)), SLOT(menuReturn(int)));
}

void FFT::menuReturn(int n)
{
  switch (n)
  {
    case FAST : { fftDisp->setMode(0); break;}
    case FALLING : { fftDisp->setMode(1); break;}
    case SMOOTH : { fftDisp->setMode(2); break;}
    case STICKY : { fftDisp->setMode(3); break;}
  }
}

void FFT::resizeEvent( QResizeEvent * )
{
}

void FFT::closeEvent( QCloseEvent *e )
{
   card->stop();
   qApp->quit();
}

void FFT::pause()
{
  muted = (!muted);
  fftwin->pause();
  if (muted) card->stop();
    else card->start_record();
}

void MYFFT::getData(freqdata *fdata)
{
  for (int i=0;i<20;i++)
    {
      vue[i]->setValue(fdata->num[i]);
    }
}

void MYFFT::setMode(int n)
{
  for (int i=0;i<20;i++)
    {
      vue[i]->setMode(n);
    }
}
