/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ASN_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"



short RdAsnLines( void ) ;
short LReAlloc1Dim( long **ptpt, long sz ) ;
short DReAlloc1Dim( double **ptpt, long sz ) ;
void LFree1Dim( long **ptpt ) ;
void DFree1Dim( double **ptpt ) ;
short LldSort123( long n, long *idx, long *is1, long *is2, double *ds3 ) ;
short LIndexx( long n, long *arrin, long *indx ) ;

long Asn_split ;






/*READ ASSIGNED LINES AND ORDER THEM*/
short RdAsnLines()
   {
   FILE *asn_fp ;
   char tstr[ FLNM_LEN + 10 ] ;
   long *idx_ary ;
   long trs_ct, asn_nolvs, rej_nolvs ;
   long jg_qn, je_qn, kag_qn, kcg_qn, kae_qn, kce_qn ;
   double erg ;


/*SET SPACE POINTERS TO NULL*/
   Aqn_vec = NULL ;
   Aerg_vec = NULL ;


/*INITIAL GLOBAL COUNTERS TO ZERO*/
   Asn_split = Rej_nolvs = Asn_nolvs = 0 ;
   Dual_Fit = 0 ;



/*OPEN ASSIGNMENT FILE FOR READING*/
   if( (asn_fp = fopen( Asn_flnm, "r" ) ) == NULL )
      return( 1 ) ;



/*LOOP THROUGH DIFFERENT ASSIGNED LINE SETS - UV DATA FIRST, MW DATA SECOND*/
   while( fscanf( asn_fp, "%s", tstr ) != EOF )
      {


   /*ASSIGN # OF ASSIGNED LINES TO ZERO*/
      rej_nolvs = asn_nolvs = 0 ;


   /*COUNT # OF ASSIGNED LINES TO ALLOCATE CORRECT AMOUNT OF SPACE -> REJECT TRANSITIONS J > JMAX*/
      for( ; strcmp( "//", tstr ); fscanf( asn_fp, "%s", tstr ), rej_nolvs++ )
         {

      /*READ END OF ASSIGNED FILE INDICATOR AND GROUND LEVEL J VALUE*/
         if( fscanf( asn_fp, "%ld%*d%*d%ld%*d%*d%*f", &je_qn, &jg_qn ) == EOF )
            {
            printf( "\nRDASNLINES -> PREMATURE EOF IN '%s' FILE !\n", Asn_flnm ) ;
            break ;
            }

      /*REJECT ASSIGNED LINES WITH TOO LARGE J*/
         if( jg_qn > J_max || je_qn > J_max )
            continue ;

      /*INCREAMENT ASSIGNED LINE COUNTER*/
         asn_nolvs++ ;
         }



   /*LOG ASSIGNMENT FILE INFORMATION -> # OF ACCEPTED LINES AND # OF REJECTED LINES INITIALLY*/
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "                              ASSIGNMENT INFORMATION !\n" ) ;
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "ASSIGNMENT FILENAME              = %s\n", Asn_flnm ) ;
      fprintf( Log_fp, "TOTAL # OF ASSIGNMENTS           = %ld\n", rej_nolvs ) ;
      fprintf( Log_fp, "LEVELS REJECTED (J > J MAX CALC) = %ld\n", rej_nolvs - asn_nolvs ) ;



   /*FILE EXISTS BUT NO ASSIGNED LINES ACCEPTED*/
      if( asn_nolvs == 0 )
         {
         fprintf( Log_fp, "\nASSIGNMENT FILE %s EXISTS BUT NO LINES ACCEPTED !\n", Asn_flnm ) ;
         fclose( asn_fp ) ;
         return( 1 ) ;
         }


   /*ALLOCATE SPACE TO ORDER QUANTUM #'S IN ORDER IN WHICH THEY ARE CALCULATED*/
      if( LReAlloc1Dim( &Aqn_vec, asn_nolvs + Asn_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nRDASNLINES (AQN_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }

   /*ALLOCATE SPACE FOR EXPERIMENTAL ENERGIES*/
      if( DReAlloc1Dim( &Aerg_vec, asn_nolvs + Asn_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nRDASNLINES (AERG_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }


   /*WHY IS THIS DEFINED ??? - CORRECT ASSIGNMENT J MAXIMUM WHEN LARGER THAN J MAXIMUM OR NEGATIVE*/
      Asn_jmax = (Asn_jmax > J_max || Asn_jmax < 0) ? J_max: Asn_jmax ;

   /*WHY IS THIS DEFINED ??? - CORRECT ASSIGNMENT K MAXIMUM WHEN LARGER THAN ASSIGNMENT K MAX OR NEGATIVE*/
      Asn_kmax = (Asn_kmax > Asn_jmax || Asn_kmax < 0) ? Asn_jmax: Asn_kmax ;



   /*REWIND ASSIGNMENT FILE AND CALCULATE OFFSET FOR QUANTUM #'S TO ORDER TRANSITIONS*/
      rewind( asn_fp ) ;

   /*UPDATE FILE POINTER FOR SECOND SET ONLY - MESSY HERE - CLEAN UP*/
      if( Asn_nolvs )
         {
         for( trs_ct = 0; trs_ct < Asn_nolvs + Rej_nolvs; trs_ct++ )
            fscanf( asn_fp, "%*s%*d%*d%*d%*d%*d%*d%*f" ) ;
         fscanf( asn_fp, "%s", tstr ) ;
         }


   /*READ ALL ASSIGNED LINES BELOW J_MAX OF CALCULATION -> REJECT MORE BASED ON ASSIGNMENT J AND K VALUES*/
      for( trs_ct = 0; trs_ct < asn_nolvs; trs_ct++ )
         {

      /*READ END OF ASSIGNED FILE INDICATOR AND GROUND LEVEL J VALUE*/
         if( fscanf( asn_fp, "%s%ld%ld%ld%ld%ld%ld%lf", tstr, &je_qn, &kae_qn, &kce_qn, &jg_qn, &kag_qn, &kcg_qn, &erg ) == EOF )
            break ;

      /*REJECT ASSIGNED LINES WITH TOO LARGE J OR K - NOTE THAT K IS NOT CHECKED ABOVE ???*/
         if( jg_qn > Asn_jmax || je_qn > Asn_jmax || kag_qn > Asn_kmax )
            {
            trs_ct-- ;
            continue ;
            }

      /*COMPACT TRANSITIONS JG, JE, TAUG, TAUE -> SAME ORDER IN WHICH THEY ARE CALCULATED*/
      /*NOTE THAT MAXIMUM J IS 255 (SHOULD BE UNSIGNED) BUT MAXIMUM J+K IS 511 - OVERFLOW WILL RESULT*/
      /*BIT SHIFTS OF <<25,<<18,<<9 WILL GIVE J MAX AT 127 BUT THEN J+K WILL NEVER EXCEED 255 ANYWAY*/
         *(Aqn_vec + trs_ct + Asn_nolvs) = (jg_qn << 24) + (je_qn << 16) +
               ((jg_qn + kag_qn - kcg_qn) << 8) + (je_qn + kae_qn - kce_qn) ;

      /*SAVE EXPERIMENTAL ENERGIES - JB NEW STYLE FORMAT WILL HAVE NO SCALE FACTOR APPLIED*/
         if( !JB_stat )
            *(Aerg_vec + trs_ct + Asn_nolvs) = erg ;

      /*JB OLD STYLE FORMAT OF ASSIGNED LINES HAS ALL LINES DIVIDED BY FACTOR - DIVIDE BY THIS FACTOR TO SCALE TO REAL*/
         else
            *(Aerg_vec + trs_ct + Asn_nolvs) = erg / JB_ergfactor ;
         }

   /*READ TILL END OF ASSIGNED LINE STRING*/
      while( strcmp( "//", tstr ) )
         if( fscanf( asn_fp, "%s", tstr ) == EOF )
            {
            fprintf( Log_fp, "\nASSIGNMENT FILE %s DOES NOT CONTAIN END OF LINE SET INDICATOR //\n", Asn_flnm ) ;
            fclose( asn_fp ) ;
            return( -1 ) ;
            }


   /*GET WEIGHTING FACTORS FOR UV AND MW DATA*/
      if( fscanf( asn_fp, "%lf", &Lsf_UVwt ) == EOF )
         {

      /*DEFAULT WEIGHTING FACTORS*/
         Lsf_UVwt = 1.0 ;
         Lsf_MWwt = 0.001 ;
         printf( "WEIGHTING FACTOR(S) NOT SPECIFIED AFTER // IN ASSIGNMENT FILE: 1.0 FRQ UNIT USED FOR UV\n" ) ;
         }

   /*DEFAULT WEIGHTING FACTORS*/
      if( fscanf( asn_fp, "%lf", &Lsf_MWwt ) == EOF )
         {
         Lsf_MWwt = 0.001 ;
         printf( "MW WEIGHTING FACTOR NOT SPECIFIED AFTER // IN ASSIGNMENT FILE: 0.001 FRQ UNIT USED FOR MW\n" ) ;
         }



   /*REDEFINE TOTAL # OF ACCEPTED LEVELS*/
      asn_nolvs = trs_ct ;
      rej_nolvs -= asn_nolvs ;


   /*LOG ASSIGNMENT INFO*/
      fprintf( Log_fp, "ASSIGNMENT J,K MAX               = %ld, %ld\n", Asn_jmax, Asn_kmax ) ;
      fprintf( Log_fp, "LEVELS REJECTED (J,KG > J,K MAX) = %ld\n", rej_nolvs ) ;
      fprintf( Log_fp, "ACCEPTED LINES                   = %ld\n", asn_nolvs ) ;
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;


   /*FILE EXISTS BUT NO ASSIGNED LINES ACCEPTED*/
      if( !asn_nolvs )
         {
         fprintf( Log_fp, "\nASSIGNMENT FILE %s EXISTS BUT NO ASSIGNED LINES ACCEPTED !\n", Asn_flnm ) ;
         fclose( asn_fp ) ;
         return( 1 ) ;
         }



   /*ALLOCATE TEMPORARY SPACE FOR STORING ORDERING INDEX ARRAY*/
      idx_ary = NULL ;
      if( LAlloc1Dim( &idx_ary, asn_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nRDASNLINES (IDX_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }

   /*ORDER TRANSITIONS IN JG, JE, TAUG, TAUE -> SAME ORDER IN WHICH THEY ARE CALCULATED*/
      LIndexx( asn_nolvs, Aqn_vec - 1 + Asn_nolvs, idx_ary - 1 ) ;
      if( LldSort123( asn_nolvs, idx_ary - 1, Aqn_vec - 1 + Asn_nolvs, (long *)NULL, Aerg_vec - 1 + Asn_nolvs ) == -1 )
         return( -1 ) ;



   /*SET GLOBAL FLAG TO INDICATE THAT DUAL FIT IS NEEDED*/
      if( Asn_nolvs )
         Dual_Fit = 1 ;

   /*ASSIGN SPLIT POINT BEFORE SECOND ITERATION - IF THERE IS ONE*/
      else
         Asn_split = asn_nolvs ;

   /*REDEFINE TOTAL NUMBER OF ACCEPTED AND REJECTED LINES*/
      Asn_nolvs += asn_nolvs ;
      Rej_nolvs += rej_nolvs ;


   /*FREE TEMPORARY SPACE*/
      LFree1Dim( &idx_ary ) ;
      }


/*CLOSE ASSIGNMENT FILE*/
   fclose( asn_fp ) ;

/*RETURN SUCCESS*/
   return( 1 ) ;
   }













/*
CombinationDiff( asn_nolvs ) ;
void CombinationDiff( long no_lvs ) ;

#define LOWERCD			0
#define UPPERCD			1

void CombinationDiff( long no_lvs )
   {
   long ls_ct, us_ct, cd_ct, cd_qn ;
   short CD_State = 1 ;

   if( CD_State == UPPERCD )
      {

      for( cd_ct = ls_ct = 0; ls_ct < no_lvs; ls_ct++ )
         {
         cd_qn = *(Aqn_vec + ls_ct) & 0x00FF00FF ;

         for( us_ct = ls_ct + 1; us_ct < no_lvs; us_ct++ )
            if( cd_qn == (*(Aqn_vec + us_ct) & 0x00FF00FF) )
               {
               cd_ct++ ;
               printf( "%ld,%ld  E-E=%lf\n", ls_ct, us_ct, Aerg_vec[ ls_ct ] - Aerg_vec[ us_ct ] ) ;
               }
         }
      }
   }
*/


/*
printf( "%ld %ld %ld %ld %ld %ld\n", jg_qn, kag_qn, kcg_qn, je_qn, kae_qn, kce_qn ) ;
for( trs_ct = 0; trs_ct < Asn_nolvs; trs_ct++ )
   printf( "%ld %ld %ld %ld\n", (*(Aqn_vec + trs_ct) >> 24), (*(Aqn_vec + trs_ct) >> 16) & 0xFF, (*(Aqn_vec + trs_ct) >> 8) & 0xFF, *(Aqn_vec + trs_ct) & 0xFF ) ;
fflush( stdout ) ;

for( cnt = 0; cnt < Asn_nolvs + asn_nolvs; cnt++ )
   printf( "Aqn_vec[ %ld ] = %ld\n", cnt, Aqn_vec[ cnt ] ) ;
*/



