// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_SCROLLBAR_H
#define KROT_SCROLLBAR_H



#include <qscrollbar.h>

class QMouseEvent;



class KRotScrollBar : public QScrollBar
{
    Q_OBJECT
    
public:

    /**
     * Constructor.
     */
    KRotScrollBar( Orientation o, QWidget *parent=0, const char *name=0 );

	
protected:

    /**
     * Get right mouse buttton press to show popup
     */
    virtual void mousePressEvent( QMouseEvent *event );


signals:

    /**
     * Right mouse button pressed inside the scrollbar
     */
    void rightButtonPressed();
};



#endif



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
