// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_CONSTANTS_H
#define KROT_CONSTANTS_H



#include "krot.h"

#include <cmath>



/**
 * @short Mathematical constants.
 *
 * Define mathematical constants used throughout the program.
 *
 * If available, we use defines from <cmath>, otherwise we calculate everything
 * on our own.
 *
 * @author Jochen Kpper
 * @version 1998/09/15
 */
class Constants {

public:

    Constants() { KROT_LAUNCH1( "Launching Constants constructor - eps = %e", eps() ); };

    /**
     * Speed of light.
     */
    static const double c() { return _c; };

    /**
     * Conversion factor cm-1 -> MHz
     */
    static const double cm2MHz() { return ( _c * 1e-4 ); };
    
    /**
     * Conversion factor cm-1 -> Hz
     */
    static const double cm2Hz() { return ( _c * 1e2 ); };
    
    /**
     * Smallest floating point number for that 1.0 + eps > 1.0.
     */
    static const double eps();

    /**
     * ln( 2 )
     */      
    static const double ln2() { return _ln2; };

    /**
     * pi
     */      
    static const double pi() { return _pi; };

    /**
     * sqrt( ln( 2 ) )
     */      
    static const double sqrt_ln2() { return _sqrt_ln2; };
    
    /**
     * sqrt( ln( 2 ) / pi )
     */      
    static const double sqrt__ln2_div_pi() { return _sqrt__ln2_div_pi; };

    /**
     * sqrt( pi )
     */      
    static const double sqrt_pi() { return _sqrt_pi; };

private:
    
    static const double _c =          299792458.0L;
    static const double _ln2 =                0.693147180559945309417232121458L;
    static const double _pi =                 3.141592653589793238462643383280L;
    static const double _sqrt_ln2 =           0.832554611157697756353164644895L;
    static const double _sqrt__ln2_div_pi =   0.469718639349825666886170164205L;
    static const double _sqrt_pi =            1.772453850905516027298167483341L;
};



#endif



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
