#ifndef __EXPORTTEX_H
#define __EXPORTTEX_H 


/*
 *    Interface for the Export TeX class.
 *
 *    As you can see, this class inherits exportFilter
 *    for defining the interface. Clone this file for
 *    further export filters.
 *
 *
 *    Dont copy this file into the korigin include path!
 *    It is not needed there.
 *
 *
 *
 *    Written by Martin Hfner for the KOrigin Project
 *
 */


#include <qobject.h>
#include <qstring.h>

#include <kconfig.h>

#include <export.h>



class exportTeX : public QObject, public exportFilter
{
  public: 
    exportTeX ();
    ~exportTeX ();

    QString getDescription ();
    const char* getFileFilter ();

    void getOptionsSlot ();
    void writeTable (const char* filename, Table* T);

    QString getLatestDirectory ();
    void setLatestDirectory (const char* dir);

    QString getDefaultDirectory ();
    void setDefaultDirectory (const char* dir);

  private:
    KConfig* k;

};



#endif





