#include "ws_tablefirstcolumn.h"
#include "worksheet.h"

#include "ws_tablefirstcolumn.moc"


// ***************************  Table First Column  ***************************


TableFirstColumn::TableFirstColumn (int numRows, QWidget* parent, const char* name) 
  : QTableView (parent, name)
  {
    setBackgroundColor( white );		// set widgets background white
    paintInverted = FALSE;
    setNumCols( 1 );			// set number of col's in table
    setNumRows( numRows );			// set number of rows in table
    setCellWidth( FIRSTCELLWIDTH );		// set width of cell in pixels
    setCellHeight( CELLHEIGHT );	       	// set height of cell in pixels
    setTableFlags( Tbl_clipCellPainting |	// avoid drawing outside cell
		   Tbl_snapToGrid |
    		   Tbl_cutCellsV |
    		   Tbl_cutCellsH);

    myworksheet = (Worksheet*) parent;     // tell me who's my parent Worksheet

    return;
  }
  

TableFirstColumn::~TableFirstColumn ()
  {
    return;
  }

  
void TableFirstColumn::paintCell( QPainter* p, int row ,int col)
  {
    int w = cellWidth( col );			// width of cell in pixels
    int h = cellHeight( row );			// height of cell in pixels
    int x2 = w - 1;
    int y2 = h - 1;
    char buffer[50];

    if ( ( myworksheet->high->isHighlighted (row, col) == TRUE ) &&
	 ( strcmp("TfiCol", myworksheet->high->whoHasHighlighted ()) == 0) )
      {
	p->setPen (NoPen);
	//	p->setBrush (QColor ("black"));
	p->setBrush (KApplication::getKApplication()->selectColor);
	p->drawRect (1, 1, x2, y2);
	p->setPen (SolidLine);
	p->setPen (KApplication::getKApplication()->selectTextColor);
      }
    else 
      {
	p->setPen (NoPen);
	p->setBrush (KApplication::getKApplication()->backgroundColor);
	p->drawRect (1, 1, x2, y2);
	
	p->setPen (SolidLine);
	p->setBrush (NoBrush);
	p->drawLine( x2, 0, x2, y2 );
	p->drawLine( 0, y2, x2, y2 );
	p->setPen (KApplication::getKApplication()->textColor);
      }

    sprintf (buffer, "%d", row+1);
    p->drawText( 0, 0, w, h, AlignCenter, buffer);
  }


void TableFirstColumn::changeTopCell (int newRow)
  {
    setTopCell (newRow);
  }


void TableFirstColumn::mousePressEvent( QMouseEvent* e )
  {
    // emit a signal to get the active WS if mousepress inside
    if (activeWS != myworksheet)
      {
        emit (changeActiveWS ());
	cout << "activeWSChanged" << endl;
      }

    int i;

    QPoint clickedPos = e->pos();	       // extract pointer position

    myworksheet->hideHighlighted ();

    // until new, no action on mid button
    if ( e->button () == MidButton ) return;
        
    // tell him to hide the infield line (input line)
    myworksheet->Tdata->setFocus (FALSE);

    // the right mousebutton needs the currentRow - not really needed
    myworksheet->curRow = findRow( clickedPos.y() );    

    if (e->button () == LeftButton)
      {
	//	int p = findRow(clickedPos.y());
	myworksheet->high->setMouseStartPos (QPoint (0, 
				   myworksheet->curRow), "TfiCol");
	myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						   myworksheet->curRow ) );
	// just update the clicked cell
	// showHighlighted ();
	update (myworksheet->curRow);
	for (i=0; i<myworksheet->T->width (); i++)
	  myworksheet->Tdata->update (myworksheet->curRow, i);
	mouseOldPos = myworksheet->high->getMouseStartPos ();
      }
    else if (e->button () == RightButton)
      {
	myworksheet->hideHighlighted ();
	clickedPos += QPoint(0,FIRSTCELLHEIGHT);
	emit (showPopup (clickedPos));
      }
  }


void TableFirstColumn::mouseMoveEvent (QMouseEvent* e)
  {
    int i, j;
    QPoint p = e->pos ();
    QPoint a;

    if ( myworksheet->high->isHighlighted () == FALSE ) return;

    if (p.y() >= (lastRowVisible()-topCell()+1)*CELLHEIGHT )
      {
	changeTopCell (topCell()+1);
	myworksheet->Tdata->changeTopCell (topCell());
	myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						   lastRowVisible ()));
      }
    else if (p.y () < 0)
      {
	changeTopCell (topCell()-1);
	myworksheet->Tdata->changeTopCell (topCell());
	myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						   topCell ()));
      }
    else
      {
      myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						 findRow(p.y())));
      }

    //    cout << mouseOldPos.y () << "    " << myworksheet->high->getMouseEndPos().y() << endl;
    
    a = myworksheet->high->getMouseEndPos ();


    if (mouseOldPos.y() == myworksheet->high->getMouseEndPos().y()) ;
    else
      {
	int luy = (a.y() < mouseOldPos.y() )? a.y() : mouseOldPos.y();
	int rly = (a.y () > mouseOldPos.y() )? a.y() : mouseOldPos.y();
	//	int lux = (a.x() < mouseOldPos.x() )? a.x() : mouseOldPos.x();
	//	int rlx = (a.x() > mouseOldPos.x() )? a.x() : mouseOldPos.x();
	
	for (j=luy; j<=rly; j++)
	  {
	    update (j);
	    for (i=0; i<=myworksheet->T->width(); i++)
	      myworksheet->Tdata->update (j,i);
	  }
      }

    mouseOldPos = a;       
  }


void TableFirstColumn::mouseReleaseEvent (QMouseEvent* e)
  {
    QPoint p = e->pos ();
    int i;

    if ( e->button () != LeftButton ) return;

    if (p.y() >= (lastRowVisible()-topCell()+1)*CELLHEIGHT )
      {
	myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						   lastRowVisible ()+1));
	changeTopCell (topCell ()+1);
	myworksheet->Tdata->changeTopCell (topCell());
      }
    else if (p.y () < 0)
      {
	myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						   topCell ()-1));
	changeTopCell (topCell()-1);
	myworksheet->Tdata->changeTopCell (topCell());
      }
    else
      myworksheet->high->setMouseEndPos (QPoint (myworksheet->T->width(), 
						 findRow(p.y())));

    // check if the cell has changed
    if (myworksheet->high->getMouseEndPos().y() == mouseOldPos.y())
      {
	if (AUTOCOPY) myworksheet->copyToClipboard ();
	return;
      }
    else 
      {
	//	int lux = myworksheet->high->getLeftX ();
	//	int rlx = myworksheet->high->getRightX ();

	update (myworksheet->high->getMouseEndPos ().y() );
	for (i=0; i<=myworksheet->T->width(); i++)
	  {
	    myworksheet->Tdata->update (myworksheet->high->getMouseEndPos ().y(),i);
	  }
      }
    if (AUTOCOPY) myworksheet->copyToClipboard ();
  }


void TableFirstColumn::resizeTableFirstColumn (int rows)
  {
    setNumRows (rows);
  }


void TableFirstColumn::update (int i)
  {
    updateCell (i,0);
  }

