#include <qwidget.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qmlined.h>
#include <qlistbox.h>
#include <qlabel.h>

#include "page.h"
#include "pg_options.h"
#include "pg_options.moc"

#include <kcolorbtn.h>
#include <kapp.h>


class PaperFormatList : public QListBox
{
public:
  PaperFormatList (QWidget* parent = 0, const char* name = 0, WFlags f = 0)
	: QListBox(parent,name,f) { }
  QListBoxItem* at (int index) { return item(index); }
};


PaperFormat::PaperFormat (const char* name, double width, double height)
  : QListBoxText()
{
  setText(name);
  the_width = width;
  the_height = height;
}


void PaperFormat::getFormat (double& width, double& height)
{
  width = the_width;
  height = the_height;
}


PageOptionsDialog::PageOptionsDialog (Page* page, QWidget* parent, 
									  const char* name, bool modal, WFlags f)
  : QDialog(parent,name,modal,f)
{
  char buffer [1024];
  QLabel* label;

  whatPage = page;

  if (whatPage == 0) {
	setCaption("Page Defaults");
  } else {
	sprintf(buffer,"%s - Page options",whatPage->caption());
	setCaption(buffer);
  }
  setFixedSize(400,300);

  formatList = new PaperFormatList(this,"item_1");
  formatList->setGeometry(120,10,150,100);
  formatList->insertItem(new PaperFormat("A3 landscape",42.0,29.7));
  formatList->insertItem(new PaperFormat("A3 portrait",29.7,42.0));
  formatList->insertItem(new PaperFormat("A4 landscape",29.7,21.0));
  formatList->insertItem(new PaperFormat("A4 portrait",21.0,29.7));
  formatList->insertItem(new PaperFormat("A5 landscape",21.0,14.8));
  formatList->insertItem(new PaperFormat("A5 portrait",14.8,21.0));
  formatList->insertItem(new PaperFormat("A6 landscape",14.8,10.5));
  formatList->insertItem(new PaperFormat("A6 portrait",10.5,14.8));
  formatList->insertItem(new PaperFormat("US Legal",21.0,11*2.54));
  connect(formatList,SIGNAL(selected(int)),SLOT(paperFormat(int)));

  if (whatPage == 0)
	sprintf(buffer,"%.2f",Page::defaultWidth);
  else
	sprintf(buffer,"%.2f",whatPage->cm_width);
  label = new QLabel(this,"item_2");
  label->setGeometry(10,10,100,20);
  label->setText("Width in cm:");
  pageWidth = new QLineEdit(this,"item_3");
  pageWidth->setGeometry(30,35,70,20);
  pageWidth->setMaxLength(15);
  pageWidth->setText(buffer);

  if (whatPage == 0)
	sprintf(buffer,"%.2f",Page::defaultHeight);
  else
	sprintf(buffer,"%.2f",whatPage->cm_height);
  label = new QLabel(this,"item_4");
  label->setGeometry(10,60,100,20);
  label->setText("Height in cm:");
  pageHeight = new QLineEdit(this,"item_5");
  pageHeight->setGeometry(30,85,70,20);
  pageHeight->setMaxLength(15);
  pageHeight->setText(buffer);

  label = new QLabel(this,"item_6");
  label->setGeometry(10,125,130,20);
  label->setText("Background color:");
  if (whatPage == 0)
	pageColor = new KColorButton(*Page::defaultColor,this,"item_7");
  else
	pageColor = new KColorButton(whatPage->the_background,this,"item_7");
  pageColor->setGeometry(150,125,60,20);

  ok = new QPushButton(this,"item_7");
  ok->setGeometry(10,265,90,25);
  ok->setText("OK");
  ok->setAutoRepeat(false);
  ok->setAutoResize(false);
  ok->setDefault(true);
  connect(ok,SIGNAL(clicked()),SLOT(OK()));

  cancel = new QPushButton(this,"item_8");
  cancel->setGeometry(300,265,90,25);
  cancel->setText("Cancel");
  cancel->setAutoRepeat(false);
  cancel->setAutoResize(false);
  cancel->setDefault(false);
  connect(cancel,SIGNAL(clicked()),SLOT(reject()));

  helpb = new QPushButton(this,"item_8");
  helpb->setGeometry(155,265,90,25);
  helpb->setText("Help");
  helpb->setAutoRepeat(false);
  helpb->setAutoResize(false);
  helpb->setDefault(false);
  connect(helpb,SIGNAL(clicked()),SLOT(help()));
}


PageOptionsDialog::~PageOptionsDialog ()
{
}


void PageOptionsDialog::OK ()
{
  cout << "PageOptionsDialog::OK()" << endl;
  apply();
  accept();
}


void PageOptionsDialog::apply ()
{
  double w, h;
  cout << "PageOptionsDialog::apply()" << endl;
  w = atof(pageWidth->text());
  h = atof(pageHeight->text());
  if (w != 0.0 && h != 0.0)
	{
	  if (whatPage == 0) {
		Page::defaultWidth = w;
		Page::defaultHeight = h;
	  } else {
		whatPage->cm_width = w;
		whatPage->cm_height = h;
	  }
	}
  if (whatPage == 0)
	*Page::defaultColor = pageColor->color();
  else
	whatPage->the_background = pageColor->color();
}


void PageOptionsDialog::help ()
{
  if (whatPage == 0)
	kapp->invokeHTMLHelp("korigin/page-defaults.html","");
  else
	kapp->invokeHTMLHelp("korigin/page-options.html","");
}


void PageOptionsDialog::paperFormat (int index)
{
  char buffer [128];
  double w, h;
  PaperFormat* format = (PaperFormat*)(formatList->at(index));
  format->getFormat(w,h);
  sprintf(buffer,"%.2f",w);
  pageWidth->setText(buffer);
  sprintf(buffer,"%.2f",h);
  pageHeight->setText(buffer);
}
