/*
 * Base Class for Numerical Fitters.
 *
 * (C) 1997 Patrick Schemitz
 * KOrigin (C) 1997 Patrick Schemitz, Martin Hfner
 *
 */

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <qobject.h>
#include <qpopmenu.h>

#include "fitter.h"
#include "fitter.moc"


FitterList& Fitters ()
{
  static FitterList fits;
  return fits;
}


void FitHelper::execFitterOptions(int i)
{
  Fitters().at(i)->execOptionsDialog();
}


static FitHelper fitMe;


/*
 * Implementation of ABC Fitter.
 *
 */


Fitter::Fitter ()
{
  inputColumns = outputColumns = 0;
}


Fitter::~Fitter ()
{
}


void Fitter::setInputColumns (Column* data)
{
  delete [] inputColumns;
  inputColumns = data;
}


void Fitter::setOutputColumns (Column* data)
{
  delete [] outputColumns;
  outputColumns = data;
}


QPopupMenu* Fitter::getFitterMenu ()
{
  Fitter* iter;
  QPopupMenu* fitter = new QPopupMenu();
  for (iter=Fitters().first(); iter!=0; iter=Fitters().next())
	fitter->insertItem(iter->name());
  return fitter;
}


QPopupMenu* Fitter::getFitterOptionsMenu ()
{
  Fitter* iter;
  QPopupMenu* fitterOptions = new QPopupMenu();
  for (iter=Fitters().first(); iter!=0; iter=Fitters().next())
    fitterOptions->insertItem(iter->name());
  QObject::connect(fitterOptions,SIGNAL(activated(int)),
				   &fitMe,SLOT(execFitterOptions(int)));
  return fitterOptions;
}
